/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.model.util;

import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.model.Flow;
import com.isencia.passerelle.model.FlowHandle;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTFacade {
    private static final Logger logger = LoggerFactory.getLogger(RESTFacade.class);
    private HttpClient httpClient = new HttpClient();

    public RESTFacade(int n, int n2) {
        HttpClientParams httpClientParams = new HttpClientParams();
        httpClientParams.setSoTimeout(n2);
        httpClientParams.setConnectionManagerTimeout((long)n);
        this.httpClient.setParams(httpClientParams);
    }

    public Collection<FlowHandle> getAllRemoteFlowHandles(URL uRL) throws PasserelleException {
        String string;
        String string2 = uRL.toString();
        if (!string2.endsWith("jobs")) {
            string2 = String.valueOf(string2) + "/jobs";
        }
        if ((string = this.invokeMethodForURL((HttpMethod)new GetMethod(string2))) != null) {
            Collection<FlowHandle> collection = this.buildFlowHandles(string);
            return collection;
        }
        return new ArrayList<FlowHandle>(0);
    }

    public Collection<FlowHandle> getAllRemoteExecutingFlowHandles(URL uRL) throws PasserelleException {
        String string = uRL.toString();
        String string2 = this.invokeMethodForURL((HttpMethod)new GetMethod(string = String.valueOf(string) + "/scheduledjobs"));
        if (string2 != null) {
            Collection<FlowHandle> collection = this.buildExecutingFlowHandles(uRL, string2);
            return collection;
        }
        return new ArrayList<FlowHandle>(0);
    }

    public Flow startFlowRemotely(Flow flow) throws PasserelleException, IllegalStateException, IllegalArgumentException {
        this.startFlowRemotely(flow.getHandle());
        return flow;
    }

    public FlowHandle startFlowRemotely(FlowHandle flowHandle) throws PasserelleException, IllegalStateException, IllegalArgumentException {
        String string = flowHandle.getAuthorativeResourceLocation().toString();
        string = String.valueOf(string) + "/launch";
        String string2 = this.invokeMethodForURL((HttpMethod)new PostMethod(string));
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = null;
        try {
            document = sAXBuilder.build((Reader)new StringReader(string2));
        }
        catch (Exception exception) {
            throw new PasserelleException("Unable to parse response data", string2, exception);
        }
        if (document != null) {
            Element element = document.getRootElement().getChild("scheduledJob");
            Element element2 = element.getChild("execInfo");
            String string3 = element2.getAttributeValue("id");
            String string4 = element2.getAttributeValue("href");
            flowHandle.setExecId(string3);
            try {
                flowHandle.setExecResourceLocation(new URL(string4));
            }
            catch (Exception exception) {
                throw new PasserelleException("Invalid URL " + string4 + " in response ", string2, exception);
            }
        }
        return flowHandle;
    }

    public FlowHandle stopFlowRemotely(FlowHandle flowHandle) throws PasserelleException, IllegalStateException, IllegalArgumentException {
        String string = String.valueOf(flowHandle.getExecResourceLocation().toString()) + "/stop";
        this.invokeMethodForURL((HttpMethod)new PostMethod(string));
        flowHandle.setExecId(null);
        flowHandle.setExecResourceLocation(null);
        return flowHandle;
    }

    public FlowHandle getRemoteFlowHandle(URL uRL) throws PasserelleException {
        String string = this.invokeMethodForURL((HttpMethod)new GetMethod(uRL.toString()));
        FlowHandle flowHandle = this.buildFlowHandle(uRL, string);
        return flowHandle;
    }

    private String invokeMethodForURL(HttpMethod httpMethod) {
        try {
            int n = this.httpClient.executeMethod(httpMethod);
            if (n != 200) {
                logger.warn("Response status error : " + httpMethod.getStatusLine());
            }
            String string = httpMethod.getResponseBodyAsString();
            if (logger.isDebugEnabled()) {
                logger.debug("Received response\n" + string);
            }
            String string2 = string;
            return string2;
        }
        catch (HttpException httpException) {
            logger.error("Fatal protocol violation: ", (Throwable)httpException);
            return null;
        }
        catch (IOException iOException) {
            logger.error("Fatal transport error: ", (Throwable)iOException);
            return null;
        }
        finally {
            httpMethod.releaseConnection();
        }
    }

    private Collection<FlowHandle> buildFlowHandles(String string) throws PasserelleException {
        ArrayList<FlowHandle> arrayList = new ArrayList<FlowHandle>();
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = null;
        try {
            document = sAXBuilder.build((Reader)new StringReader(string));
        }
        catch (Exception exception) {
            throw new PasserelleException("Unable to parse response data", string, exception);
        }
        if (document != null) {
            List list = document.getRootElement().getChildren("job");
            for (Element element : list) {
                String string2 = element.getAttributeValue("id");
                String string3 = element.getAttributeValue("href");
                String string4 = element.getAttributeValue("name");
                try {
                    FlowHandle flowHandle = new FlowHandle(new Long(string2), string4, new URL(string3));
                    arrayList.add(flowHandle);
                }
                catch (Exception exception) {
                    throw new PasserelleException("Invalid URL " + string3 + " in response ", string, exception);
                }
            }
        }
        return arrayList;
    }

    private Collection<FlowHandle> buildExecutingFlowHandles(URL uRL, String string) throws PasserelleException {
        ArrayList<FlowHandle> arrayList = new ArrayList<FlowHandle>();
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = null;
        try {
            document = sAXBuilder.build((Reader)new StringReader(string));
        }
        catch (Exception exception) {
            throw new PasserelleException("Unable to parse response data", string, exception);
        }
        if (document != null) {
            List list = document.getRootElement().getChildren("scheduledJob");
            for (Element element : list) {
                Element element2 = element.getChild("execInfo");
                String string2 = element2.getAttributeValue("id");
                String string3 = element2.getAttributeValue("href");
                Element element3 = element.getChild("job");
                String string4 = element3.getAttributeValue("id");
                String string5 = element3.getAttributeValue("href");
                String string6 = element3.getAttributeValue("name");
                try {
                    FlowHandle flowHandle = new FlowHandle(new Long(string4), string6, new URL(string5));
                    flowHandle.setExecId(string2);
                    flowHandle.setExecResourceLocation(new URL(string3));
                    arrayList.add(flowHandle);
                }
                catch (Exception exception) {
                    throw new PasserelleException("Invalid URL " + string5 + " in response ", string, exception);
                }
            }
        }
        return arrayList;
    }

    protected FlowHandle buildFlowHandle(URL uRL, String string) throws PasserelleException {
        FlowHandle flowHandle = null;
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = null;
        try {
            document = sAXBuilder.build((Reader)new StringReader(string));
        }
        catch (Exception exception) {
            throw new PasserelleException("Unable to parse response data", string, exception);
        }
        if (document != null) {
            String string2 = document.getRootElement().getChildText("id");
            String string3 = document.getRootElement().getChildText("name");
            String string4 = document.getRootElement().getChildText("modelMoml");
            flowHandle = new FlowHandle(new Long(string2), string3, uRL);
            flowHandle.setMoml(string4);
        }
        return flowHandle;
    }
}

