/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message.xml;

import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.MessageHelper;
import com.isencia.passerelle.message.xml.MessageBuilder;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xpath.XPathAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlMessageHelper {
    private static Logger logger = LoggerFactory.getLogger(XmlMessageHelper.class);

    public static ManagedMessage getMessageFromXML(String string) throws MessageException {
        return MessageBuilder.buildFromXML(string);
    }

    public static ManagedMessage fillMessageContentFromXML(ManagedMessage managedMessage, String string) throws MessageException {
        return MessageBuilder.fillFromXML(managedMessage, string);
    }

    public static String getXMLFromMessage(ManagedMessage managedMessage) throws MessageException {
        return MessageBuilder.buildToXML(managedMessage);
    }

    public static String getXMLFromMessageContent(Multipart multipart) throws MessageException {
        if (multipart == null) {
            return null;
        }
        try {
            return MessageBuilder.buildToXML(multipart);
        }
        catch (IOException iOException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", multipart, iOException);
        }
        catch (MessagingException messagingException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", multipart, messagingException);
        }
    }

    public static NodeList selectWithXPath(String string, ManagedMessage managedMessage) throws MessageException {
        Object[] objectArray = MessageHelper.getFilteredContent(managedMessage, new String[]{"text/xml", "text/plain", "text/html"});
        NodeList nodeList = null;
        boolean bl = false;
        if (objectArray != null && objectArray.length > 0) {
            try {
                int n = 0;
                while (n < objectArray.length && !bl) {
                    InputSource inputSource;
                    DocumentBuilderFactory documentBuilderFactory;
                    DocumentBuilder documentBuilder;
                    Document document;
                    if (logger.isDebugEnabled()) {
                        logger.debug("selectWithXPath() - Content :" + objectArray[n]);
                    }
                    bl = (nodeList = XPathAPI.selectNodeList((Node)(document = (documentBuilder = (documentBuilderFactory = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(inputSource = new InputSource(new StringReader(managedMessage.getBodyContentAsString())))), (String)string)).getLength() > 0;
                    ++n;
                }
            }
            catch (Exception exception) {
                throw new MessageException(PasserelleException.Severity.NON_FATAL, "", managedMessage, exception);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("selectWithXPath() - No valid content in " + managedMessage);
        }
        return nodeList;
    }

    public static String getContentWithXPath(String string, ManagedMessage managedMessage) throws MessageException {
        String string2 = null;
        NodeList nodeList = XmlMessageHelper.selectWithXPath(string, managedMessage);
        if (nodeList != null && nodeList.getLength() > 0) {
            Node node = nodeList.item(0);
            if (node.getNodeType() == 3) {
                string2 = node.getNodeValue();
            } else {
                NodeList nodeList2 = node.getChildNodes();
                if (nodeList2 != null && nodeList2.getLength() > 0) {
                    int n = 0;
                    while (n < nodeList2.getLength()) {
                        Node node2 = nodeList2.item(n);
                        if (node2.getNodeType() == 3) {
                            string2 = node.getNodeValue();
                            break;
                        }
                        ++n;
                    }
                }
            }
        }
        return string2;
    }

    public static void setContentWithXPath(String string, String string2, ManagedMessage managedMessage) throws MessageException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(managedMessage.getBodyContentAsString()));
            Document document = documentBuilder.parse(inputSource);
            XmlMessageHelper.setContentWithXPath(string, string2, document);
            OutputFormat outputFormat = new OutputFormat(document);
            outputFormat.setStandalone(false);
            StringWriter stringWriter = new StringWriter();
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
            xMLSerializer.serialize(document);
            managedMessage.setBodyContent(stringWriter.toString(), "text/xml");
        }
        catch (Exception exception) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", managedMessage, exception);
        }
    }

    private static void setContentWithXPath(String string, String string2, Document document) throws TransformerException {
        NodeList nodeList = XPathAPI.selectNodeList((Node)document, (String)string2);
        if (nodeList != null && nodeList.getLength() > 0) {
            Node node = nodeList.item(0);
            if (node.getNodeType() == 3) {
                node.setNodeValue(string);
            } else {
                NodeList nodeList2 = node.getChildNodes();
                if (nodeList2 != null && nodeList2.getLength() > 0) {
                    int n = 0;
                    while (n < nodeList2.getLength()) {
                        Node node2 = nodeList2.item(n);
                        if (node2.getNodeType() == 3) {
                            node.setNodeValue(string);
                            break;
                        }
                        ++n;
                    }
                }
            }
        }
    }
}

