/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message.xml;

import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.internal.MessageContainer;
import com.isencia.passerelle.message.internal.PasserelleBodyPart;
import com.isencia.passerelle.message.internal.SettableMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMultipart;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageBuilder {
    private static Logger logger = LoggerFactory.getLogger(MessageBuilder.class);
    private static final String rootTag = "Message";
    private static final String bodyTag = "Body";
    private static final String partTag = "Part";
    private static final String partsTag = "Parts";
    private static final String headerTag = "Header";
    private static final String contentTypeTag = "Content-Type";

    MessageBuilder() {
    }

    public static String buildToXML(ManagedMessage managedMessage) throws MessageException {
        Object object;
        SettableMessage settableMessage;
        Element element;
        Document document;
        Element element2;
        block15: {
            if (logger.isTraceEnabled()) {
                logger.trace("");
            }
            element2 = new Element(rootTag);
            document = new Document(element2);
            element = new Element(bodyTag);
            if (managedMessage != null && managedMessage instanceof SettableMessage) {
                try {
                    Element element3;
                    Object object2;
                    Header header2;
                    settableMessage = (SettableMessage)managedMessage;
                    logger.debug("Add header info");
                    if (settableMessage.getAllHeaders() != null) {
                        for (Header header2 : settableMessage.getAllHeaders()) {
                            object2 = new Element(headerTag);
                            object2.setAttribute("name", header2.getName());
                            object2.setAttribute("value", header2.getValue());
                            element2.addContent((Content)object2);
                        }
                    }
                    object = new Element(partTag);
                    element.addContent((Content)object);
                    header2 = new Element(bodyTag);
                    logger.debug("Add body headers");
                    if (settableMessage.getAllBodyHeaders() != null) {
                        for (Object object3 : settableMessage.getAllBodyHeaders()) {
                            element3 = new Element(headerTag);
                            element3.setAttribute("name", object3.getName());
                            element3.setAttribute("value", object3.getValue());
                            object.addContent((Content)element3);
                        }
                    }
                    object.addContent((Content)header2);
                    object2 = settableMessage.getBodyContent();
                    if (object2 == null) break block15;
                    logger.debug("Add body content");
                    if (object2 instanceof String) {
                        header2.setText((String)object2);
                        break block15;
                    }
                    if (object2 instanceof Multipart) {
                        Object object3;
                        MessageBuilder messageBuilder = new MessageBuilder();
                        messageBuilder.getClass();
                        object3 = messageBuilder.new MultipartContentBuilder();
                        element3 = null;
                        try {
                            element3 = ((MultipartContentBuilder)object3).build((Multipart)object2);
                        }
                        catch (IOException iOException) {
                            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", object2, iOException);
                        }
                        catch (MessagingException messagingException) {
                            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", object2, messagingException);
                        }
                        if (element3 != null) {
                            header2.addContent((Content)element3);
                        }
                        break block15;
                    }
                    header2.setText(object2.toString());
                }
                catch (IllegalDataException illegalDataException) {
                    logger.error("", (Throwable)illegalDataException);
                    throw new MessageException("illegal content for XML", managedMessage.getBodyContentAsString(), illegalDataException);
                }
            }
        }
        element2.addContent((Content)element);
        settableMessage = new XMLOutputter(Format.getPrettyFormat());
        object = settableMessage.outputString(document);
        if (logger.isTraceEnabled()) {
            logger.trace("exit");
        }
        return object;
    }

    public static String buildToXML(Multipart multipart) throws IOException, MessagingException {
        MessageBuilder messageBuilder = new MessageBuilder();
        messageBuilder.getClass();
        MultipartContentBuilder multipartContentBuilder = messageBuilder.new MultipartContentBuilder();
        Element element = multipartContentBuilder.build(multipart);
        if (element == null) {
            return null;
        }
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getCompactFormat());
        return xMLOutputter.outputString(element);
    }

    public static ManagedMessage buildFromXML(String string) throws MessageException {
        Element element3;
        MessageContainer messageContainer = new MessageContainer();
        SAXBuilder sAXBuilder = new SAXBuilder(false);
        Document document = null;
        try {
            document = sAXBuilder.build((Reader)new StringReader(string));
        }
        catch (JDOMException jDOMException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", string, jDOMException);
        }
        catch (IOException iOException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", string, iOException);
        }
        Element element2 = document.getRootElement();
        List list = element2.getChildren(headerTag);
        if (list != null && !list.isEmpty()) {
            for (Element element3 : list) {
                messageContainer.addHeader(element3.getAttributeValue("name"), element3.getAttributeValue("value"));
            }
        }
        Element element4 = element2.getChild(bodyTag);
        element3 = element4.getChild(partTag);
        MessageBuilder messageBuilder = new MessageBuilder();
        messageBuilder.getClass();
        BodyPartBuilder bodyPartBuilder = messageBuilder.new BodyPartBuilder();
        try {
            messageContainer.setBody(bodyPartBuilder.build(element3));
        }
        catch (IOException iOException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", string, iOException);
        }
        catch (MessagingException messagingException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", string, messagingException);
        }
        return messageContainer;
    }

    public static ManagedMessage fillFromXML(ManagedMessage managedMessage, String string) throws MessageException {
        Element element3;
        SettableMessage settableMessage = null;
        try {
            settableMessage = (SettableMessage)managedMessage;
        }
        catch (ClassCastException classCastException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", string, classCastException);
        }
        SAXBuilder sAXBuilder = new SAXBuilder(false);
        Document document = null;
        try {
            document = sAXBuilder.build((Reader)new StringReader(string));
        }
        catch (JDOMException jDOMException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", string, jDOMException);
        }
        catch (IOException iOException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", string, iOException);
        }
        Element element2 = document.getRootElement();
        List list = element2.getChildren(headerTag);
        if (list != null && !list.isEmpty()) {
            for (Element element3 : list) {
                settableMessage.addHeader(element3.getAttributeValue("name"), element3.getAttributeValue("value"));
            }
        }
        Element element4 = element2.getChild(bodyTag);
        element3 = element4.getChild(partTag);
        MessageBuilder messageBuilder = new MessageBuilder();
        messageBuilder.getClass();
        BodyPartBuilder bodyPartBuilder = messageBuilder.new BodyPartBuilder();
        try {
            settableMessage.setBody(bodyPartBuilder.build(element3));
        }
        catch (IOException iOException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", string, iOException);
        }
        catch (MessagingException messagingException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", string, messagingException);
        }
        return settableMessage;
    }

    private class BodyPartBuilder {
        Element partElement = new Element("Part");
        Element bodyElement = new Element("Body");

        private BodyPartBuilder() {
        }

        public PasserelleBodyPart build(Element element) throws IOException, MessagingException {
            Object object;
            Object object2;
            Element element2;
            Object object3;
            Object object4;
            PasserelleBodyPart passerelleBodyPart = new PasserelleBodyPart();
            Object object5 = "text/plain";
            Element element3 = element.getChild(MessageBuilder.bodyTag);
            Element element4 = element3.getChild(MessageBuilder.partsTag);
            if (element4 == null) {
                passerelleBodyPart.setContent(element3.getText(), (String)object5);
            } else {
                object4 = new MimeMultipart();
                object3 = element4.getChildren(MessageBuilder.partTag);
                if (object3 != null && !object3.isEmpty()) {
                    element2 = object3.iterator();
                    while (element2.hasNext()) {
                        object2 = (Element)element2.next();
                        object = new BodyPartBuilder();
                        object4.addBodyPart((BodyPart)((BodyPartBuilder)object).build((Element)object2));
                    }
                }
                passerelleBodyPart.setContent((Multipart)object4);
            }
            object4 = element.getChildren(MessageBuilder.headerTag);
            if (object4 != null && !object4.isEmpty()) {
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    element2 = (Element)object3.next();
                    object2 = element2.getAttributeValue("name");
                    object = element2.getAttributeValue("value");
                    passerelleBodyPart.addHeader((String)object2, (String)object);
                    if (!((String)object2).equals(MessageBuilder.contentTypeTag)) continue;
                    object5 = object;
                }
            }
            return passerelleBodyPart;
        }
    }

    private class BodyPartElementBuilder {
        Element partElement = new Element("Part");
        Element bodyElement = new Element("Body");

        private BodyPartElementBuilder() {
        }

        public Element build(BodyPart bodyPart) throws IOException, MessagingException {
            Object object;
            Object object2 = bodyPart.getContent();
            Enumeration enumeration = bodyPart.getAllHeaders();
            while (enumeration != null && enumeration.hasMoreElements()) {
                object = (Header)enumeration.nextElement();
                Element element = new Element(MessageBuilder.headerTag);
                element.setAttribute("name", object.getName());
                element.setAttribute("value", object.getValue());
                this.partElement.addContent((Content)element);
            }
            if (object2 instanceof String) {
                this.bodyElement.setText((String)object2);
            } else if (object2 instanceof Multipart) {
                object = new MultipartContentBuilder();
                this.bodyElement.addContent((Content)((MultipartContentBuilder)object).build((Multipart)object2));
            } else {
                boolean cfr_ignored_0 = object2 instanceof InputStream;
            }
            this.partElement.addContent((Content)this.bodyElement);
            return this.partElement;
        }
    }

    private class MultipartContentBuilder {
        Element mpElement = new Element("Parts");

        private MultipartContentBuilder() {
        }

        public Element build(Multipart multipart) throws IOException, MessagingException {
            if (logger.isTraceEnabled()) {
                logger.trace("");
            }
            if (multipart == null) {
                logger.debug("No Multipart specified");
            }
            int n = 0;
            try {
                n = multipart.getCount();
            }
            catch (MessagingException messagingException) {
                logger.debug("Unable to get count");
            }
            int n2 = 0;
            while (n2 < n) {
                BodyPart bodyPart = multipart.getBodyPart(n2);
                BodyPartElementBuilder bodyPartElementBuilder = new BodyPartElementBuilder();
                this.mpElement.addContent((Content)bodyPartElementBuilder.build(bodyPart));
                ++n2;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("exit");
            }
            if (this.mpElement.getChildren().size() == 0) {
                return null;
            }
            return this.mpElement;
        }
    }
}

