/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message.type;

import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.type.ConverterBase;
import java.lang.reflect.Constructor;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;

public class StringConverter
extends ConverterBase {
    @Override
    protected boolean areTypesCompatible(Class clazz, Type type) {
        return BaseType.STRING.equals((Object)type);
    }

    @Override
    protected boolean areTypesCompatible(Type type, Class clazz) {
        boolean bl = BaseType.STRING.equals((Object)type);
        if (clazz != null) {
            try {
                clazz.getConstructor(String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    protected Token convertContentToToken(Object object, Type type) throws UnsupportedOperationException, MessageException {
        return new StringToken(object != null ? object.toString() : null);
    }

    @Override
    protected Object convertTokenToContent(Token token, Class clazz) throws UnsupportedOperationException {
        if (token == null) {
            return null;
        }
        if (clazz != null) {
            try {
                Constructor constructor = clazz.getConstructor(String.class);
                return constructor.newInstance(((StringToken)token).stringValue());
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException();
            }
        }
        try {
            return ((StringToken)token).stringValue();
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    protected boolean areTypesCompatible(Class clazz, Class clazz2) {
        return clazz2 == null || String.class.isAssignableFrom(clazz2);
    }

    @Override
    protected Object convertContentToType(Object object, Class clazz) throws UnsupportedOperationException, MessageException {
        if (clazz != null && !String.class.equals((Object)clazz)) {
            try {
                Constructor constructor = clazz.getConstructor(String.class);
                return constructor.newInstance(object.toString());
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException();
            }
        }
        try {
            return object.toString();
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException();
        }
    }
}

