/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message;

import com.isencia.passerelle.message.ManagedMessage;
import java.util.ArrayList;
import java.util.List;

public class MultiMessageFlowElement {
    private MessageAndPort[] inputs;
    private List<MessageAndPort> outputs;
    private int nrOfOutputPorts;

    public MultiMessageFlowElement(MessageAndPort[] messageAndPortArray, int n) {
        this.inputs = messageAndPortArray;
        this.outputs = new ArrayList<MessageAndPort>();
        this.nrOfOutputPorts = n;
    }

    public MultiMessageFlowElement(int n, int n2) {
        this.inputs = new MessageAndPort[n];
        this.outputs = new ArrayList<MessageAndPort>();
        this.nrOfOutputPorts = n2;
    }

    public int getNrInputs() {
        return this.inputs.length;
    }

    public ManagedMessage getInputMessage(int n) throws IndexOutOfBoundsException {
        return this.inputs[n].message;
    }

    public int getOutputPortNr() {
        if (this.outputs.isEmpty()) {
            return 0;
        }
        return this.outputs.get((int)0).portNr;
    }

    public ManagedMessage getOutputMessage() {
        if (this.outputs.isEmpty()) {
            return this.getInputMessage(0);
        }
        return this.outputs.get((int)0).message;
    }

    public int getNrOutputSpecs() {
        return this.outputs.size();
    }

    public MessageAndPort[] getAllOutputSpecs() {
        if (this.outputs.isEmpty()) {
            return new MessageAndPort[]{new MessageAndPort(0, this.getInputMessage(0))};
        }
        return this.outputs.toArray(new MessageAndPort[this.outputs.size()]);
    }

    public void setOutputSpec(int n, ManagedMessage managedMessage) throws IllegalArgumentException {
        this.setOutputSpec(new MessageAndPort(n, managedMessage));
    }

    public void setOutputSpec(MessageAndPort messageAndPort) throws IllegalArgumentException {
        if (messageAndPort == null) {
            throw new IllegalArgumentException("Null specs are not allowed");
        }
        if (messageAndPort.portNr < 0 || messageAndPort.portNr >= this.nrOfOutputPorts) {
            throw new IllegalArgumentException("An impossible outputPortNr, port " + messageAndPort.portNr + " doesn't exist.");
        }
        if (messageAndPort.message == null) {
            throw new IllegalArgumentException("Null messages are not allowed");
        }
        this.outputs.clear();
        this.outputs.add(messageAndPort);
    }

    public void addInputSpec(int n, ManagedMessage managedMessage) throws IllegalArgumentException {
        this.addInputSpec(new MessageAndPort(n, managedMessage));
    }

    public void addInputSpec(MessageAndPort messageAndPort) throws IllegalArgumentException {
        if (messageAndPort == null) {
            throw new IllegalArgumentException("Null specs are not allowed");
        }
        if (messageAndPort.message == null) {
            throw new IllegalArgumentException("Null messages are not allowed");
        }
        try {
            this.inputs[messageAndPort.portNr] = messageAndPort;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("An impossible inPortNr, port " + messageAndPort.portNr + " doesn't exist.");
        }
    }

    public void addOutputSpec(int n, ManagedMessage managedMessage) throws IllegalArgumentException {
        this.addOutputSpec(new MessageAndPort(n, managedMessage));
    }

    public void addOutputSpec(MessageAndPort messageAndPort) throws IllegalArgumentException {
        if (messageAndPort == null) {
            throw new IllegalArgumentException("Null specs are not allowed");
        }
        if (messageAndPort.portNr < 0 || messageAndPort.portNr >= this.nrOfOutputPorts) {
            throw new IllegalArgumentException("An impossible outputPortNr, port " + messageAndPort.portNr + " doesn't exist.");
        }
        if (messageAndPort.message == null) {
            throw new IllegalArgumentException("Null messages are not allowed");
        }
        this.outputs.add(messageAndPort);
    }

    public static class MessageAndPort {
        public ManagedMessage message = null;
        public int portNr = 0;

        public MessageAndPort() {
        }

        public MessageAndPort(int n, ManagedMessage managedMessage) {
            this.portNr = n;
            this.message = managedMessage;
        }
    }
}

