/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.ext.impl;

import com.isencia.passerelle.ext.TypeConverterProvider;
import com.isencia.passerelle.message.type.TypeConverter;
import com.isencia.properties.IPropertyContainer;
import com.isencia.properties.PropertiesLoadingException;
import com.isencia.properties.PropertyContainerFactory;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTypeConverterProvider
implements TypeConverterProvider {
    private List<TypeConverter> converters = new ArrayList<TypeConverter>();
    private static final Logger logger = LoggerFactory.getLogger(DefaultTypeConverterProvider.class);

    static {
        try {
            PropertyContainerFactory.instance().registerPropertySource("passerelle-type-convertors.xml");
        }
        catch (PropertiesLoadingException propertiesLoadingException) {
            logger.warn("Could not find passerelle-type-convertors.xml. Default type converter provider disabled.");
        }
    }

    @Override
    public List<TypeConverter> getTypeConverters() {
        if (this.converters.isEmpty()) {
            this.loadConverters();
        }
        return this.converters;
    }

    private void loadConverters() {
        IPropertyContainer iPropertyContainer = PropertyContainerFactory.instance().get("com.isencia.passerelle.message.type.properties");
        if (iPropertyContainer != null) {
            String[] stringArray = iPropertyContainer.getPropertyValueList("type-converters.type-converter");
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (logger.isDebugEnabled()) {
                    logger.debug("loadConverters() - found converter " + string);
                }
                try {
                    Class<?> clazz = Class.forName(string);
                    TypeConverter typeConverter = (TypeConverter)clazz.newInstance();
                    this.converters.add(typeConverter);
                    logger.debug("loadConverters() - succesfully registered converter " + string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.error("loadConverters() - could not load converter class " + string);
                }
                catch (InstantiationException instantiationException) {
                    logger.error("loadConverters() - could not create converter object " + string, (Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    logger.error("loadConverters() - could not create converter object " + string, (Throwable)illegalAccessException);
                }
                catch (ClassCastException classCastException) {
                    logger.error("loadConverters() - incorrect converter type " + string, (Throwable)classCastException);
                }
                ++n;
            }
        }
    }

    @Override
    public String getName() {
        return "DEFAULT";
    }
}

