/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.v3;

import com.isencia.passerelle.actor.v3.MessageInputContext;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.message.ManagedMessage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ProcessRequest {
    private long iterationCount = 0L;
    private Map<String, MessageInputContext> inputContexts = new HashMap<String, MessageInputContext>();

    public long getIterationCount() {
        return this.iterationCount;
    }

    public void setIterationCount(long l) {
        this.iterationCount = l;
    }

    public void addInputMessage(int n, String string, ManagedMessage managedMessage) {
        this.inputContexts.put(string, new MessageInputContext(n, string, managedMessage));
    }

    public void addInputContext(MessageInputContext messageInputContext) {
        if (messageInputContext != null) {
            this.inputContexts.put(messageInputContext.getPortName(), messageInputContext);
        }
    }

    public ManagedMessage getMessage(Port port) {
        if (port != null) {
            return this.getMessage(port.getName());
        }
        return null;
    }

    public ManagedMessage getMessage(String string) {
        if (string != null) {
            MessageInputContext messageInputContext = this.inputContexts.get(string);
            return messageInputContext != null ? messageInputContext.getMsg() : null;
        }
        return null;
    }

    public Iterator<MessageInputContext> getAllInputContexts() {
        return this.inputContexts.values().iterator();
    }

    public boolean isEmpty() {
        return this.inputContexts.isEmpty();
    }

    public boolean hasSomethingToProcess() {
        boolean bl = false;
        Collection<MessageInputContext> collection = this.inputContexts.values();
        for (MessageInputContext messageInputContext : collection) {
            bl = !messageInputContext.isProcessed();
            if (bl) break;
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Collection<MessageInputContext> collection = this.inputContexts.values();
        MessageInputContext[] messageInputContextArray = collection.toArray(new MessageInputContext[this.inputContexts.size()]);
        stringBuffer.append("\n\tInput msgs:");
        int n = 0;
        while (n < messageInputContextArray.length) {
            MessageInputContext messageInputContext = messageInputContextArray[n];
            if (messageInputContext != null) {
                stringBuffer.append("\n\t\t" + messageInputContext.getPortName() + ": msgID=" + (messageInputContext.getMsg() != null ? messageInputContext.getMsg().getID().toString() : "null"));
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

