/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.gui;

import com.isencia.passerelle.actor.gui.PasserelleActorControllerFactory;
import com.isencia.passerelle.actor.gui.PasserelleEditorFactory;
import com.isencia.passerelle.actor.gui.PasserelleEditorPaneFactory;
import com.isencia.passerelle.model.util.CollectingMomlParsingErrorHandler;
import com.isencia.passerelle.model.util.MoMLParser;
import com.isencia.passerelle.util.EnvironmentUtils;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.gui.Configuration;
import ptolemy.data.expr.FileParameter;
import ptolemy.gui.GraphicalMessageHandler;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.EntityLibrary;
import ptolemy.moml.ErrorHandler;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.MessageHandler;

public class LibraryManager {
    public static final String USER_LIBRARY_NAME = "UserLibrary";
    public static final String ACTOR_LIBRARY_NAME = "actor library";
    private static final int ACTORS_LIBRARY_PREFIX_LENGTH = ".configuration.actor library.".length();
    private static final int USER_LIBRARY_PREFIX_LENGTH = ".configuration.UserLibrary.".length();
    private static final String SOURCE_PATH_LIB_ATTR_NAME = "_sourcePath";
    private static final Logger logger = LoggerFactory.getLogger(LibraryManager.class);
    private SortedMap<String, EntityLibrary> libraryMap;
    private SortedMap<String, EntityLibrary> userLibraryMap = new TreeMap<String, EntityLibrary>();
    private Configuration configuration;

    public LibraryManager(Configuration configuration) {
        this.configuration = configuration;
        this.refreshManagerCache(configuration);
    }

    public void refreshManagerCache(Configuration configuration) {
        if (configuration != null) {
            this.refreshActorLibraryMap(configuration);
            this.refreshUserLibraryMap(configuration);
        } else {
            if (this.libraryMap != null) {
                this.libraryMap.clear();
                this.libraryMap = null;
            }
            if (this.userLibraryMap != null) {
                this.userLibraryMap.clear();
                this.userLibraryMap = null;
            }
        }
    }

    private void refreshUserLibraryMap(Configuration configuration) {
        EntityLibrary entityLibrary;
        if (this.userLibraryMap == null) {
            this.userLibraryMap = new TreeMap<String, EntityLibrary>();
        } else {
            this.userLibraryMap.clear();
        }
        CompositeEntity compositeEntity = (CompositeEntity)configuration.getEntity(ACTOR_LIBRARY_NAME);
        if (compositeEntity != null && (entityLibrary = (EntityLibrary)compositeEntity.getEntity(USER_LIBRARY_NAME)) != null) {
            String[] stringArray;
            this.userLibraryMap.put(USER_LIBRARY_NAME, entityLibrary);
            List list = entityLibrary.entityList(EntityLibrary.class);
            CollectingMomlParsingErrorHandler collectingMomlParsingErrorHandler = new CollectingMomlParsingErrorHandler();
            List<EntityLibrary> list2 = this.getDeepLibrariesWithAttributes(list, collectingMomlParsingErrorHandler, new String[0]);
            for (Object object2 : list2) {
                stringArray = object2.getFullName().substring(ACTORS_LIBRARY_PREFIX_LENGTH);
                this.userLibraryMap.put((String)stringArray, (EntityLibrary)object2);
            }
            if (collectingMomlParsingErrorHandler.hasErrors()) {
                Object object2;
                for (Object object2 : collectingMomlParsingErrorHandler) {
                    logger.error("Error populating library " + entityLibrary.getFullName() + "\n\t" + object2.exception.getMessage());
                }
                object2 = GraphicalMessageHandler.getContext();
                Iterator<Object> iterator = new Object[]{"Ok"};
                stringArray = new String[]{"Some Library entries could not be constructed.", "Please consult the Passerelle log files for more details."};
                JOptionPane.showOptionDialog((Component)object2, stringArray, "Error", 0, 0, null, iterator, iterator[0]);
            }
        }
    }

    private void refreshActorLibraryMap(Configuration configuration) {
        if (this.libraryMap == null) {
            this.libraryMap = new TreeMap<String, EntityLibrary>();
        } else {
            this.libraryMap.clear();
        }
        CompositeEntity compositeEntity = (CompositeEntity)configuration.getEntity(ACTOR_LIBRARY_NAME);
        if (compositeEntity != null) {
            String[] stringArray;
            List list = compositeEntity.entityList(EntityLibrary.class);
            CollectingMomlParsingErrorHandler collectingMomlParsingErrorHandler = new CollectingMomlParsingErrorHandler();
            List<EntityLibrary> list2 = this.getDeepLibrariesWithAttributes(list, collectingMomlParsingErrorHandler, SOURCE_PATH_LIB_ATTR_NAME);
            for (Object object2 : list2) {
                stringArray = object2.getFullName().substring(ACTORS_LIBRARY_PREFIX_LENGTH);
                this.libraryMap.put((String)stringArray, (EntityLibrary)object2);
            }
            if (collectingMomlParsingErrorHandler.hasErrors()) {
                Object object2;
                for (Object object2 : collectingMomlParsingErrorHandler) {
                    logger.error("Error populating library " + compositeEntity.getFullName() + "\n\t" + object2.exception.getMessage());
                }
                object2 = GraphicalMessageHandler.getContext();
                Iterator<Object> iterator = new Object[]{"Ok"};
                stringArray = new String[]{"Some Library entries could not be constructed.", "Please consult the Passerelle log files for more details."};
                JOptionPane.showOptionDialog((Component)object2, stringArray, "Error", 0, 0, null, iterator, iterator[0]);
            }
        }
    }

    public String[] getActorLibraryNames() {
        if (this.libraryMap == null) {
            this.refreshActorLibraryMap(this.configuration);
        }
        if (this.libraryMap == null) {
            return new String[0];
        }
        Set<String> set = this.libraryMap.keySet();
        if (this.userLibraryMap == null) {
            this.refreshUserLibraryMap(this.configuration);
        }
        if (this.userLibraryMap != null) {
            set.addAll(this.userLibraryMap.keySet());
        }
        return set.toArray(new String[0]);
    }

    public String[] getUserLibraryNames() {
        if (this.userLibraryMap == null) {
            this.refreshUserLibraryMap(this.configuration);
        }
        if (this.userLibraryMap == null) {
            return new String[0];
        }
        Set<String> set = this.userLibraryMap.keySet();
        return set.toArray(new String[0]);
    }

    public void addSubLibrary(EntityLibrary entityLibrary, String string) throws NameDuplicationException, IllegalActionException {
        EntityLibrary entityLibrary2 = new EntityLibrary((CompositeEntity)entityLibrary, string);
        StringWriter stringWriter = new StringWriter();
        try {
            entityLibrary2.exportMoML((Writer)stringWriter, 1);
        }
        catch (IOException iOException) {}
        entityLibrary2.setName(string);
        MoMLChangeRequest moMLChangeRequest = new MoMLChangeRequest((Object)entityLibrary2, (NamedObj)entityLibrary, stringWriter.toString());
        moMLChangeRequest.addChangeListener((ChangeListener)new EntityLibraryChangedListener(this));
        entityLibrary.requestChange((ChangeRequest)moMLChangeRequest);
    }

    public void renameLibrary(EntityLibrary entityLibrary, String string) {
        String string2 = entityLibrary.getName();
        StringBuffer stringBuffer = new StringBuffer("<");
        String string3 = entityLibrary.getElementName();
        stringBuffer.append(string3);
        stringBuffer.append(" name=\"");
        stringBuffer.append(string2);
        stringBuffer.append("\">");
        if (!string2.equals(string)) {
            stringBuffer.append("<rename name=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"/>");
        }
        stringBuffer.append("</");
        stringBuffer.append(string3);
        stringBuffer.append(">");
        NamedObj namedObj = entityLibrary.getContainer();
        MoMLChangeRequest moMLChangeRequest = new MoMLChangeRequest((Object)this, namedObj, stringBuffer.toString(), null);
        moMLChangeRequest.addChangeListener((ChangeListener)new EntityLibraryChangedListener(this));
        moMLChangeRequest.setUndoable(true);
        namedObj.requestChange((ChangeRequest)moMLChangeRequest);
    }

    public void saveChangedEntityLibrary(EntityLibrary entityLibrary) {
        block19: {
            OutputStreamWriter outputStreamWriter = null;
            FileParameter fileParameter = (FileParameter)entityLibrary.getAttribute(SOURCE_PATH_LIB_ATTR_NAME);
            if (fileParameter != null) {
                try {
                    try {
                        URL uRL = fileParameter.asURL();
                        outputStreamWriter = new FileWriter(uRL.getFile());
                        entityLibrary.exportMoML((Writer)outputStreamWriter, 0);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Saved modified library ");
                        }
                    }
                    catch (Exception exception) {
                        logger.error("Failed to save update in " + fileParameter, (Throwable)exception);
                        MessageHandler.error((String)("Failed to save update in " + fileParameter), (Throwable)exception);
                        if (outputStreamWriter != null) {
                            try {
                                outputStreamWriter.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (outputStreamWriter != null) {
                        try {
                            outputStreamWriter.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            } else if (entityLibrary.getContainer() instanceof EntityLibrary) {
                this.saveChangedEntityLibrary((EntityLibrary)entityLibrary.getContainer());
            } else {
                MessageHandler.error((String)("Library update not supported for library " + entityLibrary.getName() + "\n" + SOURCE_PATH_LIB_ATTR_NAME + " attribute missing in library cfg file."));
            }
        }
    }

    public void saveEntityInUserLibrary(String string, Entity entity) throws Exception {
        EntityLibrary entityLibrary = (EntityLibrary)this.userLibraryMap.get(string);
        if (entityLibrary == null) {
            MessageHandler.error((String)("Save In Library failed: Could not find library with name \"" + string + "\"."));
            return;
        }
        this.saveEntityInLibrary(entityLibrary, entity);
    }

    public void saveEntityInLibrary(EntityLibrary entityLibrary, Entity entity) throws Exception {
        if (entityLibrary.getEntity(entity.getName()) != null) {
            throw new Exception("An object with name " + entity.getName() + " already exists in the library " + entityLibrary.getName());
        }
        Entity entity2 = this.exportEntityToClassFile(entity);
        Entity entity3 = (Entity)entity2.instantiate((NamedObj)entityLibrary, entity.getName());
        entity3.setClassName(entity.getName());
        StringWriter stringWriter = new StringWriter();
        try {
            entity3.exportMoML((Writer)stringWriter, 1);
        }
        catch (IOException iOException) {}
        MoMLChangeRequest moMLChangeRequest = new MoMLChangeRequest((Object)entity3, (NamedObj)entityLibrary, stringWriter.toString());
        moMLChangeRequest.addChangeListener((ChangeListener)new EntityLibraryChangedListener(this));
        entityLibrary.requestChange((ChangeRequest)moMLChangeRequest);
    }

    public void deleteEntityFromLibrary(EntityLibrary entityLibrary, Entity entity) {
        if (entityLibrary.getEntity(entity.getName()) == null) {
            MessageHandler.error((String)("Delete from Library failed: An object with name " + entity.getName() + " does not exist in the library " + entityLibrary.getName()));
            return;
        }
        MoMLChangeRequest moMLChangeRequest = new MoMLChangeRequest((Object)entity, (NamedObj)entityLibrary, "<deleteEntity name=\"" + entity.getName() + "\"/>\n");
        moMLChangeRequest.addChangeListener((ChangeListener)new EntityLibraryChangedListener(this));
        entityLibrary.requestChange((ChangeRequest)moMLChangeRequest);
    }

    public Entity exportEntityToClassFile(Entity entity) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Entity entity2 = (Entity)entity.clone(entity.workspace());
        entity2.setClassDefinition(true);
        if (entity2 instanceof CompositeActor) {
            object4 = (CompositeActor)entity2;
            object3 = object4.getDirector();
            if (object3 != null) {
                object3.setContainer(null);
            }
            if ((object2 = object4.getAttribute("_controllerFactory")) == null) {
                new PasserelleActorControllerFactory((NamedObj)object4, "_controllerFactory");
            } else if (!(object2 instanceof PasserelleActorControllerFactory)) {
                object2.setContainer(null);
                new PasserelleActorControllerFactory((NamedObj)object4, "_controllerFactory");
            }
            Attribute attribute = object4.getAttribute("_editorFactory");
            if (attribute == null) {
                new PasserelleEditorFactory((NamedObj)object4, "_editorFactory");
            } else if (!(attribute instanceof PasserelleEditorFactory)) {
                attribute.setContainer(null);
                new PasserelleEditorFactory((NamedObj)object4, "_editorFactory");
            }
            object = object4.getAttribute("_editorPaneFactory");
            if (object == null) {
                new PasserelleEditorPaneFactory((NamedObj)object4, "_editorPaneFactory");
            } else if (!(object instanceof PasserelleEditorPaneFactory)) {
                object.setContainer(null);
                new PasserelleEditorPaneFactory((NamedObj)object4, "_editorPaneFactory");
            }
        }
        if (this._confirmFile((File)(object4 = new File(EnvironmentUtils.getUserFolder() + File.separator + entity2.getName() + ".moml")))) {
            if (logger.isInfoEnabled()) {
                logger.info("Exporting actor " + entity2.getFullName() + " to " + ((File)object4).getPath());
            }
            object3 = entity2.getName();
            object2 = ((File)object4).getName();
            int n = ((String)object2).indexOf(".");
            object3 = n > 0 ? ((String)object2).substring(0, n) : object2;
            object = new FileWriter((File)object4);
            try {
                if (entity2.getContainer() != null) {
                    ((Writer)object).write("<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE " + entity2.getElementName() + " PUBLIC " + "\"-//UC Berkeley//DTD MoML 1//EN\"\n" + "    \"http://ptolemy.eecs.berkeley.edu" + "/xml/dtd/MoML_1.dtd\">\n");
                }
                entity2.exportMoML((Writer)object, 0, (String)object3);
            }
            finally {
                ((OutputStreamWriter)object).close();
            }
        }
        return entity2;
    }

    public boolean exportEntityToFile(Entity entity) throws IOException {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Save actor as...");
        jFileChooser.setCurrentDirectory(EnvironmentUtils.getUserRelevantDirectory());
        jFileChooser.setSelectedFile(new File(jFileChooser.getCurrentDirectory(), String.valueOf(entity.getName()) + ".xml"));
        int n = jFileChooser.showSaveDialog(null);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (!this._confirmFile(file)) {
                return false;
            }
            EnvironmentUtils.setLastSelectedDirectory(jFileChooser.getCurrentDirectory());
            if (logger.isInfoEnabled()) {
                logger.info("Exporting actor " + entity.getFullName() + " to " + file.getPath());
            }
            FileWriter fileWriter = new FileWriter(file);
            String string = entity.getName();
            String string2 = file.getName();
            int n2 = string2.indexOf(".");
            string = n2 > 0 ? string2.substring(0, n2) : string2;
            try {
                if (entity.getContainer() != null) {
                    fileWriter.write("<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE " + entity.getElementName() + " PUBLIC " + "\"-//UC Berkeley//DTD MoML 1//EN\"\n" + "    \"http://ptolemy.eecs.berkeley.edu" + "/xml/dtd/MoML_1.dtd\">\n");
                }
                entity.exportMoML((Writer)fileWriter, 0, string);
            }
            finally {
                fileWriter.close();
            }
            return true;
        }
        return false;
    }

    private boolean _confirmFile(File file) {
        String string;
        int n;
        return !file.exists() || (n = JOptionPane.showOptionDialog(null, string = "Overwrite " + file.getName() + "?", "Overwrite file?", 0, 3, null, null, null)) != 1;
    }

    private List<EntityLibrary> getDeepLibrariesWithAttributes(List<EntityLibrary> list, CollectingMomlParsingErrorHandler collectingMomlParsingErrorHandler, String ... stringArray) {
        ArrayList<EntityLibrary> arrayList = new ArrayList<EntityLibrary>();
        for (EntityLibrary entityLibrary : list) {
            Object object;
            try {
                object = MoMLParser.getErrorHandler();
                MoMLParser.setErrorHandler(collectingMomlParsingErrorHandler);
                entityLibrary.populate();
                MoMLParser.setErrorHandler((ErrorHandler)object);
            }
            catch (Exception exception) {
                logger.error("Error populating library " + entityLibrary.getFullName(), (Throwable)exception);
            }
            object = entityLibrary.entityList(EntityLibrary.class);
            if (object != null && object.size() > 0) {
                arrayList.addAll(this.getDeepLibrariesWithAttributes((List<EntityLibrary>)object, collectingMomlParsingErrorHandler, stringArray));
            }
            boolean bl = true;
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                if (entityLibrary.getAttribute(string) == null) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (!bl) continue;
            arrayList.add(entityLibrary);
        }
        return arrayList;
    }

    public static class EntityLibraryChangedListener
    implements ChangeListener {
        private LibraryManager libraryManager;

        public EntityLibraryChangedListener(LibraryManager libraryManager) {
            this.libraryManager = libraryManager;
        }

        public void changeExecuted(ChangeRequest changeRequest) {
            EntityLibrary entityLibrary = (EntityLibrary)((MoMLChangeRequest)changeRequest).getContext();
            this.libraryManager.saveChangedEntityLibrary(entityLibrary);
        }

        public void changeFailed(ChangeRequest changeRequest, Exception exception) {
        }
    }
}

