/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Source;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.data.Token;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public abstract class TriggeredSource
extends Source {
    private static Logger logger = LoggerFactory.getLogger(TriggeredSource.class);
    public static final String TRIGGER_PORT = "trigger";
    public Port trigger = PortFactory.getInstance().createInputPort((Actor)this, "trigger", null);
    private boolean triggerConnected = false;
    private PortHandler triggerHandler = null;

    public TriggeredSource(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
    }

    @Override
    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        super.doInitialize();
        boolean bl = this.triggerConnected = this.trigger.getWidth() > 0;
        if (this.triggerConnected) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(this.getInfo()) + " - Trigger(s) connected");
            }
            this.triggerHandler = new PortHandler((IOPort)this.trigger);
            this.triggerHandler.start();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    @Override
    protected boolean doPreFire() throws ProcessingException {
        boolean bl = true;
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        if (this.mustWaitForTrigger()) {
            this.waitForTrigger();
            if (this.isFinishRequested()) {
                bl = false;
            }
        }
        if (bl) {
            bl = super.doPreFire();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit " + " :" + bl);
        }
        return bl;
    }

    @Override
    protected boolean doPostFire() throws ProcessingException {
        boolean bl;
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doPostFire() - entry");
        }
        boolean bl2 = bl = !this.hasNoMoreMessages() || this.isTriggerConnected();
        if (!bl) {
            this.requestFinish();
        } else {
            bl = super.doPostFire();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doPostFire() - exit :" + bl);
        }
        return bl;
    }

    public void waitForTrigger() throws ProcessingException {
        if (this.triggerConnected) {
            Token token;
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(this.getInfo()) + " - Waiting for trigger");
            }
            if ((token = this.triggerHandler.getToken()) == null) {
                this.requestFinish();
            } else {
                try {
                    ManagedMessage managedMessage = MessageHelper.getMessageFromToken(token);
                    this.acceptTriggerMessage(managedMessage);
                }
                catch (PasserelleException passerelleException) {
                    throw new ProcessingException("Error handling token", token, passerelleException);
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info(String.valueOf(this.getInfo()) + " - Trigger received");
            }
        }
    }

    public boolean isTriggerConnected() {
        return this.triggerConnected;
    }

    protected void acceptTriggerMessage(ManagedMessage managedMessage) {
    }

    protected abstract boolean mustWaitForTrigger();
}

