/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.data.Token;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public abstract class Transformer
extends Actor {
    private static final Logger logger = LoggerFactory.getLogger(Transformer.class);
    private ManagedMessage message = null;
    public Port input = PortFactory.getInstance().createInputPort(this, null);
    private PortHandler inputHandler = null;
    public Port output = PortFactory.getInstance().createOutputPort(this);

    public Transformer(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightgrey;stroke:lightgrey\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"19\" y2=\"-19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"-19\" y2=\"19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"20\" y1=\"-19\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-19\" y1=\"20\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"19\" y1=\"-18\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-18\" y1=\"19\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<circle cx=\"0\" cy=\"0\" r=\"10\"style=\"fill:white;stroke-width:2.0\"/>\n<line x1=\"-15\" y1=\"0\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0\"/>\n<line x1=\"12\" y1=\"-3\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0\"/>\n<line x1=\"12\" y1=\"3\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0\"/>\n</svg>\n");
    }

    @Override
    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        this.inputHandler = new PortHandler((IOPort)this.input);
        if (this.input.getWidth() > 0) {
            this.inputHandler.start();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    @Override
    protected boolean doPreFire() throws ProcessingException {
        Token token;
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doPreFire() - entry");
        }
        if ((token = this.inputHandler.getToken()) != null) {
            try {
                this.message = MessageHelper.getMessageFromToken(token);
            }
            catch (PasserelleException passerelleException) {
                throw new ProcessingException("Error handling token", token, passerelleException);
            }
        } else {
            this.message = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doPreFire() - exit");
        }
        return super.doPreFire();
    }

    @Override
    protected void doFire() throws ProcessingException {
        block13: {
            if (logger.isTraceEnabled()) {
                logger.trace(this.getInfo());
            }
            if (this.message != null) {
                this.notifyStartingFireProcessing();
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.valueOf(this.getInfo()) + " - Transformer received message :" + this.message);
                    }
                    this.doFire(this.message);
                    break block13;
                }
                finally {
                    this.notifyFinishedFireProcessing();
                }
            }
            if (!this.isFinishRequested()) {
                this.requestFinish();
            } else {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected abstract void doFire(ManagedMessage var1) throws ProcessingException;

    @Override
    protected String getAuditTrailMessage(ManagedMessage managedMessage, Port port) throws Exception {
        return " sent converted message";
    }
}

