/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.core.PortListener;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageFlowElement;
import com.isencia.passerelle.message.MessageHelper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public abstract class DynamicPortsActor
extends Actor {
    public static final String NUMBER_OF_INPUTS = "Number of inputs";
    public static final String NUMBER_OF_OUTPUTS = "Number of outputs";
    public static final String INPUTPORTPREFIX = "input";
    public static final String OUTPUTPORTPREFIX = "output";
    private static Logger logger = LoggerFactory.getLogger(DynamicPortsActor.class);
    public Parameter numberOfInputs = null;
    private int nrInputPorts = 0;
    public Parameter numberOfOutputs = null;
    private int nrOutputPorts = 0;
    private List<PortHandler> handlers = new ArrayList<PortHandler>(5);
    private boolean continueFiring = true;
    protected List<Boolean> finishRequests;

    public DynamicPortsActor(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.numberOfInputs = new Parameter((NamedObj)this, NUMBER_OF_INPUTS, (Token)new IntToken(0));
        this.numberOfInputs.setTypeEquals((Type)BaseType.INT);
        this.numberOfOutputs = new Parameter((NamedObj)this, NUMBER_OF_OUTPUTS, (Token)new IntToken(0));
        this.numberOfOutputs.setTypeEquals((Type)BaseType.INT);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " attributeChanged() - entry - attribute :" + attribute);
        }
        if (attribute == this.numberOfOutputs) {
            int n = ((IntToken)this.numberOfOutputs.getToken()).intValue();
            if (n != this.nrOutputPorts) {
                try {
                    this.changeNumberOfPorts(n, this.nrOutputPorts, PortType.OUTPUT);
                }
                catch (IllegalActionException illegalActionException) {
                    throw new IllegalActionException(illegalActionException.toString());
                }
                this.nrOutputPorts = n;
            }
        } else if (attribute == this.numberOfInputs) {
            int n = ((IntToken)this.numberOfInputs.getToken()).intValue();
            if (n != this.nrInputPorts) {
                try {
                    this.changeNumberOfPorts(n, this.nrInputPorts, PortType.INPUT);
                }
                catch (IllegalActionException illegalActionException) {
                    throw new IllegalActionException(illegalActionException.toString());
                }
                this.nrInputPorts = n;
            }
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " attributeChanged() - exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFire() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doFire() - entry");
        }
        DynamicPortsActor dynamicPortsActor = this;
        synchronized (dynamicPortsActor) {
            while (this.continueFiring) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    this.continueFiring = false;
                    break;
                }
            }
        }
        this.requestFinish();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doFire() - exit");
        }
    }

    @Override
    public void doStop() {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doStop() - entry");
        }
        this.continueFiring = false;
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doStop() - exit");
        }
    }

    @Override
    public void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doInitialize() - entry");
        }
        this.continueFiring = true;
        List<Port> list = this.getInputPorts();
        for (Port port : list) {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting handler for port " + (Object)((Object)port));
            }
            PortHandler portHandler = new PortHandler((IOPort)port);
            portHandler.setListener(new HandlerPortListener(portHandler));
            this.handlers.add(portHandler);
            portHandler.start();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doInitialize() - entry");
        }
    }

    @Override
    public void doWrapUp() throws TerminationException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doWrapUp() - entry");
        }
        this.continueFiring = false;
        this.handlers.clear();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doWrapUp() - exit");
        }
    }

    protected abstract void processMessage(MessageFlowElement var1) throws ProcessingException;

    public List<Port> getInputPorts() {
        return this.inputPortList();
    }

    public int getNrInputPorts() {
        return this.nrInputPorts;
    }

    public int getNrOutputPorts() {
        return this.nrOutputPorts;
    }

    public List<Port> getOutputPorts() {
        return this.outputPortList();
    }

    private void changeNumberOfPorts(int n, int n2, PortType portType) throws IllegalActionException, IllegalArgumentException {
        String string;
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " changeNumberOfPorts() - entry - portType : " + portType + " / new nrOfPorts : " + n);
        }
        boolean bl = false;
        boolean bl2 = true;
        if (portType == PortType.INPUT) {
            bl = true;
            bl2 = false;
            string = INPUTPORTPREFIX;
        } else if (portType == PortType.OUTPUT) {
            bl = false;
            bl2 = true;
            string = OUTPUTPORTPREFIX;
        } else {
            throw new IllegalArgumentException("Unknown PortType: " + portType);
        }
        if (n < n2) {
            int n3 = n2 - 1;
            while (n3 >= 0 && n3 >= n) {
                try {
                    this.getPort(String.valueOf(string) + n3).setContainer(null);
                }
                catch (NameDuplicationException nameDuplicationException) {
                    throw new IllegalActionException(nameDuplicationException.toString());
                }
                --n3;
            }
        } else if (n > n2) {
            int n4 = n2;
            while (n4 < n) {
                this.createPort(String.valueOf(string) + n4, bl, bl2, null);
                ++n4;
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " changeNumberOfPorts() - exit");
        }
    }

    private Port createPort(String string, boolean bl, boolean bl2, Class<?> clazz) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " createPort() - entry - name : " + string);
        }
        Port port = null;
        try {
            port = (Port)this.getPort(string);
            if (port == null) {
                logger.debug(String.valueOf(this.getInfo()) + " createPort() - port " + string + " will be constructed");
                port = bl ? PortFactory.getInstance().createInputPort((Actor)this, string, clazz) : PortFactory.getInstance().createOutputPort(this, string);
                port.setMultiport(!bl);
            } else {
                logger.debug(String.valueOf(this.getInfo()) + " createPort() - port " + string + " already exists");
            }
        }
        catch (NameDuplicationException nameDuplicationException) {
            throw new IllegalActionException(nameDuplicationException.toString());
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " createPort() - exit - port : " + (Object)((Object)port));
        }
        return port;
    }

    private int getInputPortNr(String string) {
        return Integer.parseInt(string.substring(INPUTPORTPREFIX.length()));
    }

    private class HandlerPortListener
    implements PortListener {
        private PortHandler handler;
        int inputPortNr;
        private MessageFlowElement input = null;

        public HandlerPortListener(PortHandler portHandler) {
            this.handler = portHandler;
            this.inputPortNr = DynamicPortsActor.this.getInputPortNr(this.handler.getName());
        }

        @Override
        public void tokenReceived() {
            block22: {
                if (logger.isTraceEnabled()) {
                    logger.trace(String.valueOf(DynamicPortsActor.this.getInfo()) + " HandlerPortListener.tokenReceived() - entry");
                }
                Token token = this.handler.getToken();
                try {
                    ManagedMessage managedMessage = MessageHelper.getMessageFromToken(token);
                    if (managedMessage == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.valueOf(DynamicPortsActor.this.getInfo()) + " HandlerPortListener.tokenReceived() - Received null msg");
                        }
                        DynamicPortsActor.this.continueFiring = false;
                        break block22;
                    }
                    try {
                        DynamicPortsActor.this.notifyStartingFireProcessing();
                    }
                    catch (IllegalStateException illegalStateException) {}
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.valueOf(DynamicPortsActor.this.getInfo()) + " HandlerPortListener.tokenReceived() - Received msg " + managedMessage);
                    }
                    this.input = new MessageFlowElement(new MessageFlowElement.MessageAndPort(this.inputPortNr, managedMessage), DynamicPortsActor.this.nrOutputPorts);
                    try {
                        try {
                            DynamicPortsActor.this.processMessage(this.input);
                            MessageFlowElement.MessageAndPort[] messageAndPortArray = this.input.getAllOutputSpecs();
                            int n = 0;
                            while (n < messageAndPortArray.length) {
                                MessageFlowElement.MessageAndPort messageAndPort = messageAndPortArray[n];
                                Port port = (Port)DynamicPortsActor.this.getPort(DynamicPortsActor.OUTPUTPORTPREFIX + messageAndPort.portNr);
                                DynamicPortsActor.this.sendOutputMsg(port, messageAndPort.message);
                                ++n;
                            }
                        }
                        catch (ProcessingException processingException) {
                            try {
                                DynamicPortsActor.this.sendErrorMessage(processingException);
                            }
                            catch (IllegalActionException illegalActionException) {
                                logger.error(DynamicPortsActor.this.getInfo(), (Throwable)illegalActionException);
                            }
                            try {
                                DynamicPortsActor.this.notifyFinishedFireProcessing();
                            }
                            catch (IllegalStateException illegalStateException) {}
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            DynamicPortsActor.this.notifyFinishedFireProcessing();
                        }
                        catch (IllegalStateException illegalStateException) {}
                        throw throwable;
                    }
                    try {
                        DynamicPortsActor.this.notifyFinishedFireProcessing();
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
                catch (Exception exception) {
                    logger.error(DynamicPortsActor.this.getInfo(), (Throwable)exception);
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace(String.valueOf(DynamicPortsActor.this.getInfo()) + " HandlerPortListener.tokenReceived() - exit");
            }
        }

        @Override
        public void noMoreTokens() {
            if (logger.isTraceEnabled()) {
                logger.trace(String.valueOf(DynamicPortsActor.this.getInfo()) + " HandlerPortListener.noMoreTokens() - entry");
            }
            DynamicPortsActor.this.continueFiring = false;
            if (logger.isTraceEnabled()) {
                logger.trace(String.valueOf(DynamicPortsActor.this.getInfo()) + " HandlerPortListener.noMoreTokens() - exit");
            }
        }
    }

    private static class PortType {
        static final PortType INPUT = new PortType("INPUT");
        static final PortType OUTPUT = new PortType("OUTPUT");
        private String name;

        private PortType(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

