/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.ui.hierarchy;

import com.python.pydev.ui.hierarchy.HierarchyNodeModel;
import com.python.pydev.ui.hierarchy.HierarchyNodeView;
import com.rc.retroweaver.runtime.Autobox;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.swt.PSWTCanvas;
import edu.umd.cs.piccolox.swt.PSWTPath;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.widgets.Composite;
import org.python.pydev.core.Tuple;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyViewer
extends PSWTCanvas {
    public Set<HierarchyNodeView> allAdded = new HashSet<HierarchyNodeView>();

    public HierarchyViewer(Composite parent, int args) {
        super(parent, args);
    }

    public void setHierarchy(HierarchyNodeModel initialNode) {
        this.getLayer().setTransform(new AffineTransform());
        this.getLayer().removeAllChildren();
        this.allAdded.clear();
        if (initialNode == null) {
            initialNode = new HierarchyNodeModel("Invalid");
        }
        HashSet<HierarchyNodeModel> nodesAdded = new HashSet<HierarchyNodeModel>();
        double y = 10.0;
        double x = 10.0;
        HierarchyNodeView initial = new HierarchyNodeView(this, initialNode, x, y, Color.LIGHT_GRAY);
        this.allAdded.add(initial);
        this.getLayer().addChild(initial.node);
        nodesAdded.add(initialNode);
        ArrayList<HierarchyNodeView> nodesToAdd = new ArrayList<HierarchyNodeView>();
        nodesToAdd.add(initial);
        this.addWithDelta(y + 40.0, x, nodesToAdd, 40.0, true);
        nodesToAdd = new ArrayList();
        nodesToAdd.add(initial);
        double lastY = this.addWithDelta(y - 40.0, x, nodesToAdd, -40.0, false);
        this.getLayer().translate(0.0, -lastY - 40.0 - y);
    }

    private double addWithDelta(double y, double initialX, List<HierarchyNodeView> nodesToAdd, double yDelta, boolean addChildren) {
        ArrayList<HierarchyNodeView> newRound;
        do {
            double x = initialX;
            newRound = new ArrayList<HierarchyNodeView>();
            for (HierarchyNodeView v : nodesToAdd) {
                Tuple<List<HierarchyNodeView>, Double> tup = this.addNodesFor(v, addChildren ? v.model.children : v.model.parents, y, x, addChildren);
                for (HierarchyNodeView added : (List)tup.o1) {
                    if (newRound.contains(added)) continue;
                    newRound.add(added);
                }
                x = (Double)tup.o2;
            }
            nodesToAdd = newRound;
            y += yDelta;
        } while (newRound.size() > 0);
        return y;
    }

    private Tuple<List<HierarchyNodeView>, Double> addNodesFor(HierarchyNodeView initial, List<HierarchyNodeModel> toAdd, double y, double x, boolean addChildren) {
        ArrayList<HierarchyNodeView> ret = new ArrayList<HierarchyNodeView>();
        block0: for (HierarchyNodeModel node : toAdd) {
            HierarchyNodeView view = new HierarchyNodeView(this, node, x, y);
            if (!this.allAdded.contains(view)) {
                PBounds bounds = this.addNode(initial, view, addChildren);
                x = bounds.x + bounds.width + 10.0;
                this.getLayer().addChild(view.node);
                ret.add(view);
                this.allAdded.add(view);
                continue;
            }
            for (HierarchyNodeView added : this.allAdded) {
                if (!added.equals(view)) continue;
                this.addNode(initial, added, addChildren);
                continue block0;
            }
        }
        return new Tuple(ret, (Object)Autobox.valueOf((double)x));
    }

    private PBounds addNode(HierarchyNodeView from, HierarchyNodeView toNode, boolean addChildren) {
        PBounds bounds = toNode.node.getBounds();
        final PSWTPath path = new PSWTPath();
        Point2D to = toNode.node.getCenter();
        Point2D fromP = from.node.getCenter();
        if (!addChildren) {
            fromP.setLocation(fromP.getX(), fromP.getY() - from.node.getHeight() / 2.0);
            to.setLocation(to.getX(), to.getY() + toNode.node.getHeight() / 2.0);
        } else {
            fromP.setLocation(fromP.getX(), fromP.getY() + from.node.getHeight() / 2.0);
            to.setLocation(to.getX(), to.getY() - toNode.node.getHeight() / 2.0);
        }
        path.setPathToPolyline(new Point2D[]{fromP, to});
        this.getLayer().addChild(path);
        path.moveToBack();
        path.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseEntered(PInputEvent event) {
                path.setStrokeColor(Color.LIGHT_GRAY);
            }

            public void mouseExited(PInputEvent event) {
                path.setStrokeColor(Color.BLACK);
            }
        });
        return bounds;
    }
}

