/*
 * Decompiled with CFR 0.152.
 */
package joptsimple.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import joptsimple.internal.ReflectionException;
import joptsimple.internal.ValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflection {
    Reflection() {
        throw new UnsupportedOperationException();
    }

    public static <V> ValueConverter<V> findConverter(Class<V> clazz) {
        ValueConverter<V> valueOf = Reflection.valueOfConverter(clazz);
        if (valueOf != null) {
            return valueOf;
        }
        ValueConverter<V> constructor = Reflection.constructorConverter(clazz);
        if (constructor != null) {
            return constructor;
        }
        throw new IllegalArgumentException(clazz + " is not a value type");
    }

    private static <V> ValueConverter<V> valueOfConverter(final Class<V> clazz) {
        try {
            final Method valueOf = clazz.getDeclaredMethod("valueOf", String.class);
            if (!Reflection.meetsConverterRequirements(valueOf, clazz)) {
                return null;
            }
            return new ValueConverter<V>(){

                @Override
                public V convert(String value) {
                    return clazz.cast(Reflection.invoke(valueOf, value));
                }

                @Override
                public Class<V> valueType() {
                    return clazz;
                }
            };
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
    }

    private static <V> ValueConverter<V> constructorConverter(final Class<V> clazz) {
        try {
            final Constructor<V> ctor = clazz.getConstructor(String.class);
            return new ValueConverter<V>(){

                @Override
                public V convert(String value) {
                    return Reflection.instantiate(ctor, value);
                }

                @Override
                public Class<V> valueType() {
                    return clazz;
                }
            };
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
    }

    public static <T> T instantiate(Constructor<T> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Exception ex) {
            throw Reflection.reflectionException(ex);
        }
    }

    public static Object invoke(Method method, Object ... args) {
        try {
            return method.invoke(null, args);
        }
        catch (Exception ex) {
            throw Reflection.reflectionException(ex);
        }
    }

    private static boolean meetsConverterRequirements(Method method, Class<?> expectedReturnType) {
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && expectedReturnType.equals(method.getReturnType());
    }

    private static RuntimeException reflectionException(Exception ex) {
        if (ex instanceof IllegalArgumentException) {
            return new ReflectionException(ex);
        }
        if (ex instanceof InvocationTargetException) {
            return new ReflectionException(ex.getCause());
        }
        if (ex instanceof RuntimeException) {
            return (RuntimeException)ex;
        }
        return new ReflectionException(ex);
    }
}

