/*
 * Decompiled with CFR 0.152.
 */
package joptsimple;

import java.util.Collection;
import java.util.StringTokenizer;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentList;
import joptsimple.OptionArgumentConversionException;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.internal.Reflection;
import joptsimple.internal.ReflectionException;
import joptsimple.internal.Strings;
import joptsimple.internal.ValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArgumentAcceptingOptionSpec<V>
extends AbstractOptionSpec<V> {
    private static final char NIL_VALUE_SEPARATOR = '\u0000';
    private final boolean argumentRequired;
    private ValueConverter<V> converter;
    private String argumentDescription = "";
    private String valueSeparator = String.valueOf('\u0000');

    ArgumentAcceptingOptionSpec(String option, boolean argumentRequired) {
        super(option);
        this.argumentRequired = argumentRequired;
    }

    ArgumentAcceptingOptionSpec(Collection<String> options, boolean argumentRequired, String description) {
        super(options, description);
        this.argumentRequired = argumentRequired;
    }

    public <T> ArgumentAcceptingOptionSpec<T> ofType(Class<T> argumentType) {
        this.converter = Reflection.findConverter(argumentType);
        return this;
    }

    public final ArgumentAcceptingOptionSpec<V> describedAs(String description) {
        this.argumentDescription = description;
        return this;
    }

    public final ArgumentAcceptingOptionSpec<V> withValuesSeparatedBy(char separator) {
        if (separator == '\u0000') {
            throw new IllegalArgumentException("cannot use U+0000 as separator");
        }
        this.valueSeparator = String.valueOf(separator);
        return this;
    }

    @Override
    final void handleOption(OptionParser parser, ArgumentList arguments, OptionSet detectedOptions, String detectedArgument) {
        if (Strings.isNullOrEmpty(detectedArgument)) {
            this.detectOptionArgument(parser, arguments, detectedOptions);
        } else {
            this.addArguments(detectedOptions, detectedArgument);
        }
    }

    protected void addArguments(OptionSet detectedOptions, String detectedArgument) {
        StringTokenizer lexer = new StringTokenizer(detectedArgument, this.valueSeparator);
        while (lexer.hasMoreTokens()) {
            detectedOptions.addWithArgument(this, lexer.nextToken());
        }
    }

    protected abstract void detectOptionArgument(OptionParser var1, ArgumentList var2, OptionSet var3);

    @Override
    protected final V convert(String argument) {
        if (this.converter == null) {
            return (V)argument;
        }
        try {
            return this.converter.convert(argument);
        }
        catch (ReflectionException ex) {
            throw new OptionArgumentConversionException(this.options(), argument, this.converter.valueType(), ex);
        }
    }

    protected boolean canConvertArgument(String argument) {
        StringTokenizer lexer = new StringTokenizer(argument, this.valueSeparator);
        try {
            while (lexer.hasMoreTokens()) {
                this.convert(lexer.nextToken());
            }
            return true;
        }
        catch (OptionException ignored) {
            return false;
        }
    }

    protected boolean isArgumentOfNumberType() {
        return this.converter != null && Number.class.isAssignableFrom(this.converter.valueType());
    }

    @Override
    boolean acceptsArguments() {
        return true;
    }

    @Override
    boolean requiresArgument() {
        return this.argumentRequired;
    }

    String argumentDescription() {
        return this.argumentDescription;
    }

    Class<?> argumentType() {
        return this.converter == null ? String.class : this.converter.valueType();
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        ArgumentAcceptingOptionSpec other = (ArgumentAcceptingOptionSpec)that;
        return this.requiresArgument() == other.requiresArgument();
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (this.argumentRequired ? 0 : 1);
    }
}

