/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.status;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class LinkContributionItem
extends ContributionItem {
    private static final int DEFAULT_CHAR_WIDTH = 40;
    private int charWidth;
    private CLabel link;
    private Composite statusLine = null;
    private String text = "";
    private int widthHint = -1;
    private int heightHint = -1;
    private MouseListener mouseListener;
    private Image image;
    private String tooltip;

    public LinkContributionItem(String string) {
        this(string, 40);
    }

    public LinkContributionItem(String string, int n) {
        super(string);
        this.charWidth = n;
        this.setVisible(false);
    }

    public void fill(Composite composite) {
        StatusLineLayoutData statusLineLayoutData;
        this.statusLine = composite;
        Label label = new Label(composite, 2);
        this.link = new CLabel(this.statusLine, 32);
        if (this.mouseListener != null) {
            this.link.addMouseListener(this.mouseListener);
        }
        if (this.image != null) {
            this.link.setImage(this.image);
        }
        if (this.tooltip != null) {
            this.link.setToolTipText(this.tooltip);
        }
        if (this.widthHint < 0) {
            statusLineLayoutData = new GC((Drawable)this.statusLine);
            statusLineLayoutData.setFont(this.statusLine.getFont());
            FontMetrics fontMetrics = statusLineLayoutData.getFontMetrics();
            this.widthHint = fontMetrics.getAverageCharWidth() * this.charWidth;
            this.heightHint = fontMetrics.getHeight();
            statusLineLayoutData.dispose();
        }
        statusLineLayoutData = new StatusLineLayoutData();
        statusLineLayoutData.widthHint = this.widthHint;
        this.link.setLayoutData((Object)statusLineLayoutData);
        this.link.setText(this.text);
        statusLineLayoutData = new StatusLineLayoutData();
        statusLineLayoutData.heightHint = this.heightHint;
        label.setLayoutData((Object)statusLineLayoutData);
    }

    public Point getDisplayLocation() {
        if (this.link != null && this.statusLine != null) {
            return this.statusLine.toDisplay(this.link.getLocation());
        }
        return null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        Assert.isNotNull((Object)string);
        this.text = this.escape(string);
        if (this.link != null && !this.link.isDisposed()) {
            this.link.setText(this.text);
        }
        this.updateManager();
    }

    private void updateManager() {
        if (this.text.length() == 0) {
            if (this.isVisible()) {
                this.setVisible(false);
                IContributionManager iContributionManager = this.getParent();
                if (iContributionManager != null) {
                    iContributionManager.update(true);
                }
            }
        } else if (!this.isVisible()) {
            this.setVisible(true);
            IContributionManager iContributionManager = this.getParent();
            if (iContributionManager != null) {
                iContributionManager.update(true);
            }
        }
    }

    private String escape(String string) {
        return Util.replaceAll((String)string, (String)"&", (String)"&&");
    }

    public void setToolTipText(String string) {
        Assert.isNotNull((Object)this.text);
        this.tooltip = this.escape(string);
        if (this.link != null && !this.link.isDisposed()) {
            this.link.setToolTipText(string);
        }
        this.updateManager();
    }

    public void setImage(Image image) {
        this.image = image;
        if (this.link != null && !this.link.isDisposed()) {
            this.link.setImage(image);
        }
        this.updateManager();
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (this.link != null) {
            this.link.addMouseListener(mouseListener);
            this.mouseListener = null;
        } else {
            this.mouseListener = mouseListener;
        }
    }
}

