/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.xml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;
import uk.ac.gda.common.rcp.util.EclipseUtils;
import uk.ac.gda.richbeans.xml.XMLBeanContentDescriberFactory;
import uk.ac.gda.richbeans.xml.string.StringInput;
import uk.ac.gda.richbeans.xml.string.StringStorage;

public class XMLEditorManager {
    public static void openXmlEditorsFromFiles(List<IFile> list) throws Exception {
        ArrayList<IStorageEditorInput> arrayList = new ArrayList<IStorageEditorInput>(list.size());
        for (IFile iFile : list) {
            arrayList.add((IStorageEditorInput)new FileEditorInput(iFile));
        }
        XMLEditorManager.openXmlEditors(arrayList);
    }

    public static void openXmlEditorsFromStrings(List<String> list) throws Exception {
        ArrayList<IStorageEditorInput> arrayList = new ArrayList<IStorageEditorInput>(list.size());
        for (String string : list) {
            arrayList.add(new StringInput(new StringStorage(string)));
        }
        XMLEditorManager.openXmlEditors(arrayList);
    }

    public static void openXmlEditors(List<IStorageEditorInput> list) throws Exception {
        Object object;
        String string;
        IWorkbenchPage iWorkbenchPage = EclipseUtils.getActivePage();
        if (iWorkbenchPage == null) {
            throw new Exception("Active page not found!");
        }
        List<String> list2 = XMLEditorManager.getIds(list);
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        ArrayList<String> arrayList = new ArrayList<String>(iEditorReferenceArray.length);
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            string = iEditorReferenceArray[n].getId();
            if (!list2.contains(string) || arrayList.contains(string)) {
                object = iEditorReferenceArray[n].getEditor(false);
                if (object.isDirty()) {
                    object.doSave((IProgressMonitor)new NullProgressMonitor());
                }
                iWorkbenchPage.closeEditor(object, false);
            }
            arrayList.add(string);
            ++n;
        }
        n = 0;
        while (n < list.size()) {
            string = list.get(n);
            object = list2.get(n);
            IEditorReference[] iEditorReferenceArray2 = iWorkbenchPage.findEditors(null, (String)object, 2);
            if (iEditorReferenceArray2 != null && iEditorReferenceArray2.length > 0) {
                int n2 = 0;
                while (n2 < iEditorReferenceArray2.length) {
                    IEditorPart iEditorPart = iEditorReferenceArray2[n2].getEditor(false);
                    if (iEditorPart instanceof IReusableEditor) {
                        if (iEditorPart.isDirty()) {
                            iEditorPart.doSave((IProgressMonitor)new NullProgressMonitor());
                        }
                        iWorkbenchPage.reuseEditor((IReusableEditor)iEditorPart, (IEditorInput)string);
                        break;
                    }
                    ++n2;
                }
            } else {
                iWorkbenchPage.openEditor((IEditorInput)string, (String)object);
            }
            ++n;
        }
    }

    private static List<String> getIds(List<IStorageEditorInput> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (IStorageEditorInput iStorageEditorInput : list) {
            arrayList.add(XMLBeanContentDescriberFactory.getInstance().getId(iStorageEditorInput));
        }
        return arrayList;
    }
}

