/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.editors.xml.bean;

import com.swtdesigner.SWTResourceManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.richbeans.editors.xml.bean.ColorManager;
import uk.ac.gda.richbeans.editors.xml.bean.IXMLColorConstants;
import uk.ac.gda.richbeans.editors.xml.bean.NonRuleBasedDamagerRepairer;
import uk.ac.gda.richbeans.editors.xml.bean.XMLDoubleClickStrategy;
import uk.ac.gda.richbeans.editors.xml.bean.XMLScanner;
import uk.ac.gda.richbeans.editors.xml.bean.XMLTagScanner;
import uk.ac.gda.util.schema.SchemaReader;

public class XMLConfiguration
extends SourceViewerConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(XMLConfiguration.class);
    private XMLDoubleClickStrategy doubleClickStrategy;
    private XMLTagScanner tagScanner;
    private XMLScanner scanner;
    private ColorManager colorManager;
    private SchemaReader schemaReader;
    private static Pattern END = Pattern.compile("^.*\\<\\/(.+)\\>.*$");
    private static Pattern SIBLING = Pattern.compile("^.*\\<(.+)\\>.*$");

    public XMLConfiguration(ColorManager colorManager, URL uRL) throws Exception {
        this.colorManager = colorManager;
        try {
            this.schemaReader = new SchemaReader(uRL);
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Cannot create Schema reader for " + uRL);
        }
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_tag"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer iSourceViewer, String string) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new XMLDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected XMLScanner getXMLScanner() {
        if (this.scanner == null) {
            this.scanner = new XMLScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IXMLColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    protected XMLTagScanner getXMLTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new XMLTagScanner(this.colorManager);
            this.tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IXMLColorConstants.TAG))));
        }
        return this.tagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        DefaultDamagerRepairer defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getXMLTagScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__xml_tag");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__xml_tag");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__dftl_partition_content_type");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer nonRuleBasedDamagerRepairer = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(IXMLColorConstants.XML_COMMENT)));
        presentationReconciler.setDamager((IPresentationDamager)nonRuleBasedDamagerRepairer, "__xml_comment");
        presentationReconciler.setRepairer((IPresentationRepairer)nonRuleBasedDamagerRepairer, "__xml_comment");
        return presentationReconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
        ContentAssistant contentAssistant = new ContentAssistant();
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)new XMLCompletionProcessor(), "__dftl_partition_content_type");
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)new XMLCompletionProcessor(), "__xml_tag");
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)new XMLCompletionProcessor(), "__xml_comment");
        contentAssistant.enableAutoActivation(true);
        contentAssistant.setAutoActivationDelay(1);
        return contentAssistant;
    }

    public List<String> getParents(ITextViewer iTextViewer, int n) {
        try {
            ITypedRegion iTypedRegion = iTextViewer.getDocument().getPartition(n);
            String string = iTextViewer.getDocument().get(iTypedRegion.getOffset(), iTypedRegion.getLength());
            String string2 = string.trim().replace("\n", "");
            Matcher matcher = END.matcher(string2);
            if (matcher.matches()) {
                return Arrays.asList(matcher.group(1));
            }
            matcher = SIBLING.matcher(string2);
            if (matcher.matches()) {
                String string3 = matcher.group(1);
                return this.schemaReader != null ? this.schemaReader.getParents(string3) : Collections.EMPTY_LIST;
            }
        }
        catch (Exception exception) {
            logger.debug("Problem determining tag at position.", (Throwable)exception);
            return null;
        }
        return null;
    }

    private void filterCurrentlyTyped(ITextViewer iTextViewer, int n, List<String> list) {
        try {
            ITypedRegion iTypedRegion = iTextViewer.getDocument().getPartition(n);
            String string = iTextViewer.getDocument().get(iTypedRegion.getOffset(), iTypedRegion.getLength());
            String string2 = string.substring(string.indexOf("<") + 1, string.indexOf(10)).trim();
            if (string2 != null && !"".equals(string2)) {
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string3 = iterator.next();
                    if (string3.startsWith(string2)) continue;
                    iterator.remove();
                }
            }
        }
        catch (Exception exception) {
            logger.debug("Problem filtering tags.", (Throwable)exception);
        }
    }

    private int getNumberCharactersTyped(ITextViewer iTextViewer, int n) {
        try {
            String string = iTextViewer.getDocument().get(n, 1);
            int n2 = 0;
            while (!"<".equals(string)) {
                string = iTextViewer.getDocument().get(n - ++n2, 1);
            }
            return n2 - 1;
        }
        catch (Exception exception) {
            logger.debug("Problem filtering tags.", (Throwable)exception);
            return 0;
        }
    }

    public class XMLCompletionProcessor
    implements IContentAssistProcessor {
        private final Image tagImage = SWTResourceManager.getImage(XMLConfiguration.class, "/icons/tag.png");
        private final char[] CHARS = new char[]{'<'};

        public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
            List<String> list = XMLConfiguration.this.getParents(iTextViewer, n);
            ArrayList arrayList = new ArrayList(31);
            if (XMLConfiguration.this.schemaReader != null) {
                try {
                    for (String string : list) {
                        arrayList.addAll(XMLConfiguration.this.schemaReader.getChildTags(string));
                    }
                }
                catch (Exception exception) {
                    return null;
                }
            }
            XMLConfiguration.this.filterCurrentlyTyped(iTextViewer, n, arrayList);
            int n2 = XMLConfiguration.this.getNumberCharactersTyped(iTextViewer, n);
            ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[arrayList.size()];
            int n3 = 0;
            for (String string : arrayList) {
                CompletionProposal completionProposal = new CompletionProposal(String.valueOf(string.substring(n2)) + "></" + string + ">", n, 0, string.length() + 1 - n2, this.tagImage, String.valueOf(string) + "></" + string + ">", null, null);
                iCompletionProposalArray[n3] = completionProposal;
                ++n3;
            }
            return iCompletionProposalArray;
        }

        public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
            return null;
        }

        public char[] getCompletionProposalAutoActivationCharacters() {
            return this.CHARS;
        }

        public char[] getContextInformationAutoActivationCharacters() {
            return null;
        }

        public IContextInformationValidator getContextInformationValidator() {
            return null;
        }

        public String getErrorMessage() {
            return null;
        }
    }
}

