/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.editors;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.EditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.beans.BeansFactory;
import uk.ac.gda.common.rcp.util.EclipseUtils;
import uk.ac.gda.richbeans.beans.BeanUI;
import uk.ac.gda.richbeans.beans.IExpressionWidget;
import uk.ac.gda.richbeans.beans.IFieldProvider;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.editors.BeanExpressionManager;
import uk.ac.gda.richbeans.editors.DirtyContainer;
import uk.ac.gda.richbeans.editors.RichBeanEditorOperation;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;
import uk.ac.gda.util.beans.xml.XMLHelpers;

public abstract class RichBeanEditorPart
extends EditorPart
implements ValueListener,
IReusableEditor,
IFieldProvider {
    private static final Logger logger = LoggerFactory.getLogger(RichBeanEditorPart.class);
    protected Object editingBean;
    protected Object previousUndoBean;
    protected final DirtyContainer dirtyContainer;
    protected String path;
    protected final URL mappingURL;
    private boolean undoStackActive = true;
    private boolean isDisposed = false;
    protected IUndoContext undoableContext;
    protected boolean addedListenersAndSwitchedOn = false;
    protected List<String> expressionFields;

    protected abstract String getRichEditorTabText();

    public RichBeanEditorPart(String string, URL uRL, DirtyContainer dirtyContainer, Object object) {
        this.path = string;
        this.mappingURL = uRL;
        this.dirtyContainer = dirtyContainer;
        this.editingBean = object;
        try {
            this.previousUndoBean = BeansFactory.deepClone((Object)object);
        }
        catch (Exception exception) {
            try {
                logger.error("Cannot clone editing bean.", (Throwable)exception);
                this.previousUndoBean = object.getClass().newInstance();
            }
            catch (Exception exception2) {
                logger.error("Cannot instantiate editing bean.", (Throwable)exception2);
            }
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        if (this.path == null) {
            return;
        }
        File file = new File(this.path);
        iProgressMonitor.beginTask(file.getName(), 100);
        try {
            try {
                BeanUI.uiToBean(this, this.editingBean);
                WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor iProgressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
                        try {
                            XMLHelpers.writeToXML((URL)RichBeanEditorPart.this.mappingURL, (Object)RichBeanEditorPart.this.editingBean, (String)RichBeanEditorPart.this.path);
                            IFile iFile = RichBeanEditorPart.this.getIFile();
                            if (iFile != null) {
                                iFile.refreshLocal(0, null);
                            }
                        }
                        catch (Exception exception) {
                            throw new InvocationTargetException(exception);
                        }
                    }
                };
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)workspaceModifyOperation);
                this.notifyFileSaved(file);
                this.dirtyContainer.setDirty(false);
            }
            catch (Exception exception) {
                logger.error("Cannot save file", (Throwable)exception);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void notifyFileSaved(File file) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        if (this.dirtyContainer != null) {
            this.dirtyContainer.setDirty(false);
        }
    }

    public IFile getIFile() {
        return EclipseUtils.getIFile(this.getEditorInput());
    }

    public void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        if (iEditorInput != null) {
            this.setPartName(iEditorInput.getName());
        }
    }

    public Object getEditingBean() throws Exception {
        BeanUI.uiToBean(this, this.editingBean);
        return this.editingBean;
    }

    public String getPath() {
        return this.path;
    }

    protected final void setEditingBean(Object object) {
        this.editingBean = object;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public void setUndoableContext(IUndoContext iUndoContext) {
        this.undoableContext = iUndoContext;
    }

    @Override
    public void valueChangePerformed(ValueEvent valueEvent) {
        this.dirtyContainer.setDirty(true);
        this.recordUndoableEvent(valueEvent.getFieldName());
    }

    protected void recordUndoableEvent(String string) {
        if (!this.isUndoStackActive()) {
            return;
        }
        try {
            if (Thread.currentThread() != this.getSite().getShell().getDisplay().getThread()) {
                return;
            }
            Object object = BeansFactory.deepClone((Object)this.previousUndoBean);
            Object object2 = BeansFactory.deepClone((Object)this.editingBean);
            BeanUI.uiToBean(this, object2);
            object2 = BeansFactory.deepClone((Object)object2);
            if (this.previousUndoBean != null && this.previousUndoBean.equals(object2)) {
                return;
            }
            RichBeanEditorOperation richBeanEditorOperation = new RichBeanEditorOperation(string, object, object2, this);
            richBeanEditorOperation.addContext(this.undoableContext);
            OperationHistoryFactory.getOperationHistory().add((IUndoableOperation)richBeanEditorOperation);
            this.previousUndoBean = object2;
            this.getEditorSite().getActionBars().updateActionBars();
        }
        catch (Exception exception) {
            logger.error("Unable to add event to stack " + this.editingBean.toString(), (Throwable)exception);
        }
    }

    @Override
    public String getValueListenerName() {
        return "DirtyListener";
    }

    public boolean isDirty() {
        if (this.path == null) {
            return false;
        }
        return this.dirtyContainer.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void linkUI(boolean bl) {
        try {
            BeanUI.switchState(this.editingBean, this, false);
            BeanUI.beanToUI(this.editingBean, this);
            BeanUI.switchState(this.editingBean, this, true);
            if (!this.addedListenersAndSwitchedOn) {
                BeanUI.addValueListener(this.editingBean, this, this);
                BeanUI.setBeanFields(this.editingBean, this);
                this.addedListenersAndSwitchedOn = true;
                BeanUI.notify(this.editingBean, this, new BeanUI.BeanProcessor(){

                    @Override
                    public void process(Map.Entry<Object, Object> entry, IFieldWidget iFieldWidget) throws Exception {
                        if (iFieldWidget instanceof IExpressionWidget) {
                            IExpressionWidget iExpressionWidget = (IExpressionWidget)iFieldWidget;
                            BeanExpressionManager beanExpressionManager = new BeanExpressionManager(iExpressionWidget, RichBeanEditorPart.this);
                            beanExpressionManager.setAllowedSymbols(RichBeanEditorPart.this.getExpressionFields());
                            iExpressionWidget.setExpressionManager(beanExpressionManager);
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            logger.error("Cannot push values from bean to UI in linkUI()", (Throwable)exception);
        }
    }

    protected List<String> getExpressionFields() throws Exception {
        if (this.expressionFields == null) {
            this.expressionFields = BeanUI.getEditingFields(this.editingBean, this);
        }
        return this.expressionFields;
    }

    @Override
    public IFieldWidget getField(String string) throws Exception {
        return BeanUI.getFieldWiget(string, this);
    }

    @Override
    public Object getFieldValue(String string) throws Exception {
        return this.getField(string).getValue();
    }

    public void dispose() {
        this.setDisposed(true);
        super.dispose();
        try {
            BeanUI.dispose(this.editingBean, this);
        }
        catch (Exception exception) {
            logger.error("Cannot dispose parts as expected", (Throwable)exception);
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void setDisposed(boolean bl) {
        this.isDisposed = bl;
    }

    public boolean isUndoStackActive() {
        return this.undoStackActive;
    }

    public void setUndoStackActive(boolean bl) {
        this.undoStackActive = bl;
    }
}

