/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.FunctionTable;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.OperatorSet;

public class ExpressionUtils {
    private static JEP PARSER;
    private static List<String> OPERATORS;
    private static List<String> CONSTANTS;
    private static List<String> FUNCTIONS;
    private static List<String> FUNCTIONS_BRACKETS;

    private static JEP getParser() {
        if (PARSER == null) {
            PARSER = new JEP();
            PARSER.addStandardFunctions();
            PARSER.addStandardConstants();
            PARSER.setAllowUndeclared(true);
        }
        return PARSER;
    }

    public static final List<String> getOperators() {
        if (OPERATORS == null) {
            ArrayList<String> arrayList = new ArrayList<String>(31);
            JEP jEP = ExpressionUtils.getParser();
            OperatorSet operatorSet = jEP.getOperatorSet();
            Operator[] operatorArray = operatorSet.getOperators();
            int n = operatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Operator operator = operatorArray[n2];
                arrayList.add(operator.getSymbol());
                ++n2;
            }
            OPERATORS = Collections.unmodifiableList(arrayList);
        }
        return OPERATORS;
    }

    public static boolean isOperator(String string) {
        return ExpressionUtils.getOperators().contains(string);
    }

    public static final List<String> getConstants() {
        if (CONSTANTS == null) {
            ArrayList<String> arrayList = new ArrayList<String>(31);
            JEP jEP = ExpressionUtils.getParser();
            for (Object e : jEP.getSymbolTable().keySet()) {
                arrayList.add(e.toString());
            }
            CONSTANTS = Collections.unmodifiableList(arrayList);
        }
        return CONSTANTS;
    }

    public static boolean isConstant(String string) {
        return ExpressionUtils.getConstants().contains(string);
    }

    public static String getLastTerm(String string) {
        if (string == null || "".equals(string)) {
            return "";
        }
        for (String string2 : ExpressionUtils.getOperators()) {
            if (!string.endsWith(string2)) continue;
            return "";
        }
        if (string.endsWith("(")) {
            return "";
        }
        try {
            String string2;
            string2 = ExpressionUtils.getParser();
            Node node = string2.parseExpression(string);
            ArrayList<Node> arrayList = new ArrayList<Node>(1);
            ExpressionUtils.getLastNode(node, arrayList);
            Node node2 = (Node)arrayList.get(0);
            if (node2 instanceof ASTVarNode) {
                String string3 = ((ASTVarNode)node2).getName();
                return string3;
            }
            if (node2 instanceof ASTConstant) {
                String string4 = ((ASTConstant)node2).getValue().toString();
                return string4;
            }
        }
        catch (Exception exception) {
            return "";
        }
        return "";
    }

    private static void getLastNode(Node node, List<Node> list) {
        if (node.jjtGetNumChildren() < 1) {
            list.clear();
            list.add(node);
            return;
        }
        int n = 0;
        while (n < node.jjtGetNumChildren()) {
            Node node2 = node.jjtGetChild(n);
            ExpressionUtils.getLastNode(node2, list);
            ++n;
        }
    }

    public static final List<String> getFunctions() {
        if (FUNCTIONS == null) {
            ArrayList<String> arrayList = new ArrayList<String>(31);
            ArrayList<String> arrayList2 = new ArrayList<String>(31);
            JEP jEP = ExpressionUtils.getParser();
            FunctionTable functionTable = jEP.getFunctionTable();
            for (Object e : functionTable.keySet()) {
                arrayList.add(e.toString());
                arrayList2.add(String.valueOf(e.toString()) + "(");
            }
            FUNCTIONS = Collections.unmodifiableList(arrayList);
            FUNCTIONS_BRACKETS = Collections.unmodifiableList(arrayList2);
        }
        return FUNCTIONS;
    }

    public static Collection<? extends String> getFunctionsWithOpeningBrackets() {
        ExpressionUtils.getFunctions();
        return FUNCTIONS_BRACKETS;
    }
}

