/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.StyledText;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.richbeans.beans.IExpressionManager;
import uk.ac.gda.richbeans.beans.IExpressionWidget;
import uk.ac.gda.richbeans.beans.IFieldProvider;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.editors.ExpressionContentProposalProvider;
import uk.ac.gda.richbeans.editors.ExpressionLabelProvider;
import uk.ac.gda.richbeans.editors.StyledTextContentAdapter;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;
import uk.ac.gda.util.list.SortNatural;

public class BeanExpressionManager
implements IExpressionManager,
ValueListener {
    private static final Logger logger = LoggerFactory.getLogger(BeanExpressionManager.class);
    private double value;
    private boolean expressionValid;
    private String expression;
    private IFieldProvider provider;
    private IExpressionWidget widget;
    private Collection<String> fields;
    private JEP jepParser;
    private List<IFieldWidget> precedents = new ArrayList<IFieldWidget>(7);
    private ExpressionContentProposalProvider proposalProvider;

    public BeanExpressionManager(IExpressionWidget iExpressionWidget, IFieldProvider iFieldProvider) {
        this.widget = iExpressionWidget;
        this.provider = iFieldProvider;
        this.jepParser = new JEP();
        this.jepParser.addStandardFunctions();
        this.jepParser.addStandardConstants();
        this.jepParser.setAllowUndeclared(false);
        this.jepParser.setImplicitMul(true);
    }

    @Override
    public double getExpressionValue() {
        return this.value;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(String string) {
        this.expression = string;
        try {
            if (string == null) {
                this.value = Double.NaN;
                this.expressionValid = false;
            }
            this.value = this.calculateValue();
            this.expressionValid = !Double.isNaN(this.value) && !Double.isInfinite(this.value);
            this.updateListeners();
        }
        catch (Exception exception) {
            this.clearListeners();
            this.value = Double.NaN;
            this.expressionValid = false;
        }
    }

    private void updateListeners() throws Exception {
        this.clearListeners();
        if (!this.expressionValid) {
            return;
        }
        Node node = this.jepParser.parse(this.expression);
        this.parseNode(node, this.precedents);
        for (IFieldWidget iFieldWidget : this.precedents) {
            iFieldWidget.addValueListener(this);
        }
    }

    private void clearListeners() {
        for (IFieldWidget iFieldWidget : this.precedents) {
            try {
                iFieldWidget.removeValueListener(this);
            }
            catch (Throwable throwable) {}
        }
        this.precedents.clear();
    }

    @Override
    public void valueChangePerformed(ValueEvent valueEvent) {
        if (valueEvent.getFieldName() == null) {
            return;
        }
        this.jepParser.addVariable(valueEvent.getFieldName(), valueEvent.getDoubleValue());
        this.value = this.jepParser.getValue();
        this.widget.setExpressionValue(this.value);
    }

    private void parseNode(Node node, List<IFieldWidget> list) throws Exception {
        if (node instanceof ASTVarNode) {
            IFieldWidget iFieldWidget = this.getWidget((ASTVarNode)node);
            if (iFieldWidget != null) {
                list.add(iFieldWidget);
            }
            return;
        }
        int n = 0;
        while (n < node.jjtGetNumChildren()) {
            Node node2 = node.jjtGetChild(n);
            this.parseNode(node2, list);
            ++n;
        }
    }

    private IFieldWidget getWidget(ASTVarNode aSTVarNode) {
        try {
            return this.provider.getField(aSTVarNode.getName());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private double calculateValue() {
        for (String string : this.fields) {
            Object object;
            try {
                object = this.provider.getFieldValue(string);
            }
            catch (Exception exception) {
                continue;
            }
            if (!(object instanceof Number)) continue;
            this.jepParser.addVariable(string, ((Number)object).doubleValue());
        }
        this.jepParser.parseExpression(this.getExpression());
        return this.jepParser.getValue();
    }

    @Override
    public Collection<String> getAllowedSymbols() throws Exception {
        return this.fields;
    }

    @Override
    public void setAllowedSymbols(Collection<String> collection) throws Exception {
        HashSet<String> hashSet = new HashSet<String>(collection);
        if (this.widget.getFieldName() != null) {
            hashSet.remove(this.widget.getFieldName());
        }
        ArrayList<String> arrayList = new ArrayList<String>(hashSet.size());
        arrayList.addAll(hashSet);
        Collections.sort(arrayList, new SortNatural(false));
        this.fields = arrayList;
        String[] stringArray = this.fields.toArray(new String[this.fields.size()]);
        if (this.widget.getControl() instanceof StyledText) {
            if (this.proposalProvider == null) {
                this.proposalProvider = new ExpressionContentProposalProvider(stringArray, this.widget);
                ContentProposalAdapter contentProposalAdapter = new ContentProposalAdapter(this.widget.getControl(), (IControlContentAdapter)new StyledTextContentAdapter(), (IContentProposalProvider)this.proposalProvider, null, null);
                contentProposalAdapter.setLabelProvider((ILabelProvider)new ExpressionLabelProvider(this.fields));
                contentProposalAdapter.setPropagateKeys(true);
                contentProposalAdapter.setProposalAcceptanceStyle(2);
            } else {
                this.proposalProvider.setProposals(stringArray);
            }
        }
    }

    @Override
    public boolean isExpressionValid() {
        return this.expressionValid;
    }

    @Override
    public String getValueListenerName() {
        return String.valueOf(this.widget.getFieldName()) + " " + this.getClass().getName();
    }
}

