/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.wrappers;

import com.swtdesigner.SWTResourceManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import uk.ac.gda.richbeans.components.wrappers.TextWrapper;

public class RegularExpressionTextWrapper
extends TextWrapper {
    protected CLabel messageLabel;
    protected Image errorImage;
    protected Image nameImage;
    protected Pattern pattern;
    private ModifyListener modifyListener;

    public RegularExpressionTextWrapper(Composite composite, int n, Pattern pattern) {
        super(composite, n);
        this.pattern = pattern;
        this.messageLabel = new CLabel((Composite)this, 0);
        this.messageLabel.setLayoutData((Object)"East");
        this.errorImage = SWTResourceManager.getImage(RegularExpressionTextWrapper.class, "/icons/error.png");
        this.nameImage = SWTResourceManager.getImage(RegularExpressionTextWrapper.class, "/icons/tick.png");
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                RegularExpressionTextWrapper.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RegularExpressionTextWrapper.this.checkValue();
                    }
                });
            }
        };
        this.text.addModifyListener(this.modifyListener);
    }

    @Override
    public void dispose() {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.removeModifyListener(this.modifyListener);
            this.text.dispose();
        }
        super.dispose();
    }

    @Override
    public void setValue(Object object) {
        super.setValue(object);
        this.checkValue();
    }

    protected void checkValue() {
        if (!this.isActive() || !this.isOn()) {
            return;
        }
        Object object = this.getValue();
        if (object == null || "".equals(object)) {
            this.setWrongValue(object);
            return;
        }
        try {
            Matcher matcher = this.pattern.matcher((String)object);
            if (matcher.matches()) {
                this.setRightValue(object);
            } else {
                this.setWrongValue(object);
            }
        }
        catch (Exception exception) {
            this.setWrongValue(null);
        }
        this.layout();
        this.redraw();
    }

    protected void setRightValue(Object object) {
        this.messageLabel.setImage(this.getNameImage());
        this.text.setForeground(BLACK);
        this.setToolTipText("The value '" + object + "' is valid.");
    }

    protected void setWrongValue(Object object) {
        this.messageLabel.setImage(this.getErrorImage());
        this.setToolTipText("The value '" + object + "' is not valid.");
        this.text.setForeground(RED);
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.messageLabel.setToolTipText(string);
        this.text.setToolTipText(string);
    }

    public Image getErrorImage() {
        return this.errorImage;
    }

    public void setErrorImage(Image image) {
        this.errorImage = image;
    }

    public Image getNameImage() {
        return this.nameImage;
    }

    public void setNameImage(Image image) {
        this.nameImage = image;
    }
}

