/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.wrappers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.EventManagerDelegate;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;

public class RadioWrapper
extends Group
implements IFieldWidget {
    protected final EventManagerDelegate eventDelegate;
    protected final Map<String, Button> buttonMap;
    protected final Map<String, SelectionListener> listenerMap;
    private boolean isOn = false;
    private boolean active = true;
    protected String fieldName;

    public RadioWrapper(Composite composite, int n, String[] stringArray) {
        super(composite, 0);
        this.setLayout((Layout)new RowLayout());
        this.eventDelegate = new EventManagerDelegate(this);
        this.buttonMap = new HashMap<String, Button>(7);
        this.listenerMap = new HashMap<String, SelectionListener>(7);
        int n2 = 0;
        while (n2 < stringArray.length) {
            final Button button = new Button((Composite)this, 0x10 | n);
            button.setText(stringArray[n2]);
            this.buttonMap.put(stringArray[n2], button);
            SelectionAdapter selectionAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ValueEvent valueEvent = new ValueEvent(button, RadioWrapper.this.getFieldName());
                    valueEvent.setValue(RadioWrapper.this.getValue());
                    RadioWrapper.this.eventDelegate.notifyValueListeners(valueEvent);
                }
            };
            this.listenerMap.put(stringArray[n2], (SelectionListener)selectionAdapter);
            button.addSelectionListener((SelectionListener)selectionAdapter);
            ++n2;
        }
    }

    @Override
    public void dispose() {
        for (String string : this.buttonMap.keySet()) {
            this.buttonMap.get(string).removeSelectionListener(this.listenerMap.get(string));
        }
        super.dispose();
    }

    @Override
    public Object getValue() {
        for (String string : this.buttonMap.keySet()) {
            if (!this.buttonMap.get(string).getSelection()) continue;
            return string;
        }
        return null;
    }

    @Override
    public void setValue(Object object) {
        for (String string : this.buttonMap.keySet()) {
            if (string.equals(object)) {
                this.buttonMap.get(string).setSelection(true);
                continue;
            }
            this.buttonMap.get(string).setSelection(false);
        }
    }

    public void clear() {
        for (String string : this.buttonMap.keySet()) {
            this.buttonMap.get(string).setSelection(false);
        }
    }

    protected void checkSubclass() {
    }

    @Override
    public boolean isOn() {
        return this.isOn;
    }

    @Override
    public void off() {
        this.isOn = false;
    }

    @Override
    public void on() {
        this.isOn = true;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
        this.setVisible(bl);
    }

    @Override
    public void addValueListener(ValueListener valueListener) {
        this.eventDelegate.addValueListener(valueListener);
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void setFieldName(String string) {
        this.fieldName = string;
    }

    @Override
    public void fireValueListeners() {
        ValueEvent valueEvent = new ValueEvent(this, this.getFieldName());
        valueEvent.setValue(this.getValue());
        this.eventDelegate.notifyValueListeners(valueEvent);
    }

    @Override
    public void fireBoundsUpdaters() {
        ValueEvent valueEvent = new ValueEvent(this, this.getFieldName());
        valueEvent.setValue(this.getValue());
        this.eventDelegate.notifyBoundsProviderListeners(valueEvent);
    }

    @Override
    public void removeValueListener(ValueListener valueListener) {
        this.eventDelegate.removeValueListener(valueListener);
    }
}

