/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.wrappers;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import swing2swt.layout.BorderLayout;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.FieldComposite;
import uk.ac.gda.richbeans.event.ValueEvent;

public class PrintfWrapper
extends FieldComposite
implements IFieldWidget {
    private static final String[] DEFAULT_FORMATS = new String[]{"10.7f", "5.2f", "6.4f", "10.7g", "5.2g", "6.4g"};
    protected final Combo combo;
    protected final Label formatLabel;
    protected AutoCompleteField autoComplete;
    private SelectionAdapter selectionListener;
    private ModifyListener modifyListener;
    private SelectionAdapter oneListener;
    private SelectionAdapter hundredListener;
    private SelectionAdapter ninesListener;
    private MenuItem oneItem;
    private MenuItem hundredItem;
    private MenuItem ninesItem;
    private Double templateFormatNumber = 1.0;

    public PrintfWrapper(Composite composite, int n) {
        super(composite, 0);
        this.setLayout(new BorderLayout());
        this.combo = new Combo((Composite)this, n);
        this.combo.setLayoutData((Object)"Center");
        this.mainControl = this.combo;
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ValueEvent valueEvent = new ValueEvent(PrintfWrapper.this.combo, PrintfWrapper.this.getFieldName());
                valueEvent.setDoubleValue(PrintfWrapper.this.combo.getSelectionIndex());
                valueEvent.setValue(PrintfWrapper.this.getValue());
                PrintfWrapper.this.eventDelegate.notifyValueListeners(valueEvent);
            }
        };
        this.combo.addSelectionListener((SelectionListener)this.selectionListener);
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = PrintfWrapper.this.combo.getText();
                PrintfWrapper.this.addDrop(string);
                ValueEvent valueEvent = new ValueEvent(PrintfWrapper.this.combo, PrintfWrapper.this.getFieldName());
                valueEvent.setDoubleValue(PrintfWrapper.this.combo.getSelectionIndex());
                valueEvent.setValue(PrintfWrapper.this.getValue());
                PrintfWrapper.this.eventDelegate.notifyValueListeners(valueEvent);
            }
        };
        this.combo.addModifyListener(this.modifyListener);
        this.formatLabel = new Label((Composite)this, 0);
        this.formatLabel.setAlignment(0x1000000);
        this.formatLabel.setLayoutData((Object)"East");
        this.formatLabel.setText("        ");
        this.formatLabel.setToolTipText("This is " + this.templateFormatNumber + " formatted with the current format. Right click to change the test number.");
        Menu menu = new Menu((Control)this.formatLabel);
        this.formatLabel.setMenu(menu);
        this.oneItem = new MenuItem(menu, 0);
        this.oneItem.setText("Format '1.0'");
        this.oneListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PrintfWrapper.this.templateFormatNumber = 1.0;
                PrintfWrapper.this.updateFormat("" + PrintfWrapper.this.getValue());
            }
        };
        this.oneItem.addSelectionListener((SelectionListener)this.oneListener);
        this.hundredItem = new MenuItem(menu, 0);
        this.hundredItem.setText("Format '100.0001'");
        this.hundredListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PrintfWrapper.this.templateFormatNumber = 100.0001;
                PrintfWrapper.this.updateFormat("" + PrintfWrapper.this.getValue());
            }
        };
        this.hundredItem.addSelectionListener((SelectionListener)this.hundredListener);
        this.ninesItem = new MenuItem(menu, 0);
        this.ninesItem.setText("Format '99999'");
        this.ninesListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PrintfWrapper.this.templateFormatNumber = 99999.0;
                PrintfWrapper.this.updateFormat("" + PrintfWrapper.this.getValue());
            }
        };
        this.ninesItem.addSelectionListener((SelectionListener)this.ninesListener);
        this.setItems(DEFAULT_FORMATS);
    }

    @Override
    public void dispose() {
        this.combo.removeSelectionListener((SelectionListener)this.selectionListener);
        this.combo.removeModifyListener(this.modifyListener);
        this.oneItem.removeSelectionListener((SelectionListener)this.oneListener);
        this.hundredItem.removeSelectionListener((SelectionListener)this.hundredListener);
        this.ninesItem.removeSelectionListener((SelectionListener)this.ninesListener);
        super.dispose();
    }

    private void addDrop(String string) {
        if (!this.updateFormat(string)) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(11);
        arrayList.addAll(Arrays.asList(this.combo.getItems()));
        if (!arrayList.contains(string)) {
            arrayList.add(0, string);
            this.setItems(arrayList.toArray(new String[arrayList.size()]));
            this.combo.setText(string);
        }
    }

    private boolean updateFormat(String string) {
        try {
            String string2 = string.startsWith("%") ? string : "%" + string;
            String string3 = String.format(string2, this.templateFormatNumber);
            this.formatLabel.setText("   " + string3 + "   ");
            this.layout();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setItems(String[] stringArray) {
        this.combo.setItems(stringArray);
        if (this.autoComplete == null) {
            this.autoComplete = new AutoCompleteField((Control)this.combo, (IControlContentAdapter)new ComboContentAdapter(), stringArray);
        }
        this.autoComplete.setProposals(stringArray);
    }

    @Override
    public Object getValue() {
        String string = this.combo.getText();
        int n = this.combo.getSelectionIndex();
        if (n < 0 && string != null) {
            return string;
        }
        if (n > -1) {
            return this.combo.getItem(n);
        }
        return null;
    }

    @Override
    public void setValue(Object object) {
        if (object == null) {
            this.combo.clearSelection();
            if (this.combo.getSelectionIndex() != -1) {
                throw new IllegalArgumentException("Attempted to clearSelection of Read Only PrintfWrapper " + this.getFieldName());
            }
            return;
        }
        String string = object.toString();
        int n = this.combo.indexOf(string);
        if (n < 0) {
            this.combo.setText(string);
            this.addDrop(string);
        } else {
            this.combo.select(n);
        }
    }

    @Override
    public void setActive(boolean bl) {
        super.setActive(bl);
        this.combo.setVisible(bl);
    }

    public void setTextLimit(int n) {
        this.combo.setTextLimit(n);
    }

    public void select(int n) {
        this.combo.select(n);
    }

    public void setForeground(Color color) {
        if (color.isDisposed()) {
            return;
        }
        this.combo.setForeground(color);
    }

    public int getSelectionIndex() {
        return this.combo.getSelectionIndex();
    }

    public String getItem(int n) {
        return this.combo.getItem(n);
    }

    public String[] getItems() {
        return this.combo.getItems();
    }
}

