/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.selector;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.beans.BeansFactory;
import uk.ac.gda.common.rcp.util.GridUtils;
import uk.ac.gda.richbeans.beans.BeanUI;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.EventManagerDelegate;
import uk.ac.gda.richbeans.components.FieldBeanComposite;
import uk.ac.gda.richbeans.components.selector.BeanSelectionEvent;
import uk.ac.gda.richbeans.components.selector.BeanSelectionListener;
import uk.ac.gda.richbeans.components.selector.BeanWrapper;
import uk.ac.gda.richbeans.components.selector.ListEditorUI;
import uk.ac.gda.richbeans.components.selector.ListEditorUIAdapter;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;

public abstract class ListEditor
extends FieldBeanComposite {
    private static final Logger logger = LoggerFactory.getLogger(ListEditor.class);
    protected final List<BeanWrapper> beans = new ArrayList<BeanWrapper>(7);
    protected final Map<BeanWrapper, String> takenNames = new HashMap<BeanWrapper, String>(7);
    protected EventManagerDelegate eventDelegate;
    protected String nameField;
    protected int listHeight;
    protected int listWidth;
    protected int maxItems;
    protected int minItems;
    protected String defaultName;
    private ListEditorUI listEditorUI;
    protected BeanWrapper lastSelectionBean = null;
    private String templateName;

    public abstract StructuredViewer getViewer();

    public void setListVisible(boolean bl) {
        GridUtils.setVisibleAndLayout(this.getViewer().getControl(), bl);
    }

    public ListEditor(Composite composite, int n, String string) {
        super(composite, n, string);
    }

    protected void updateEditingUIVisibility() {
        if (this.editorUI instanceof Control) {
            ((Control)this.editorUI).setVisible(!this.beans.isEmpty());
        }
    }

    @Override
    public Object getValue() {
        ArrayList<Object> arrayList = new ArrayList<Object>(7);
        for (BeanWrapper beanWrapper : this.beans) {
            arrayList.add(beanWrapper.getBean());
        }
        return arrayList;
    }

    @Override
    public void addValueListener(ValueListener valueListener) {
        this.eventDelegate.addValueListener(valueListener);
        super.addValueListener(valueListener);
    }

    @Override
    public void removeValueListener(ValueListener valueListener) {
        this.eventDelegate.removeValueListener(valueListener);
        super.removeValueListener(valueListener);
    }

    @Override
    public void setEditorUI(Object object) {
        if (object instanceof Control) {
            Control control = (Control)object;
            if (control.getLayoutData() == null) {
                control.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            }
            control.setVisible(false);
        }
        super.setEditorUI(object);
    }

    public void setValue(int n, String string, Object object) throws Exception {
        BeanWrapper beanWrapper = this.beans.get(n);
        BeansFactory.setBeanValue((Object)beanWrapper.getBean(), (String)string, (Object)object);
        if (n == this.getSelectedIndex()) {
            BeanUI.beanToUI(beanWrapper.getBean(), this.editorUI);
        }
    }

    public abstract int getSelectedIndex();

    protected abstract void updateButtons();

    public void setSelectedIndex(int n) {
        this.setSelectedBean(this.beans.get(n), true);
    }

    public void setField(String string, Object object) throws Exception {
        IFieldWidget iFieldWidget = BeanUI.getFieldWiget(string, this.editorUI);
        iFieldWidget.setValue(object);
        iFieldWidget.fireValueListeners();
    }

    @Override
    public Object getBean() {
        return this.beans.get(this.getSelectedIndex()).getBean();
    }

    public int getListSize() {
        return this.beans.size();
    }

    public String getNameField() {
        return this.nameField;
    }

    public void setNameField(String string) {
        this.nameField = string;
    }

    public int getListHeight() {
        return this.listHeight;
    }

    public void setListHeight(int n) {
        this.listHeight = n;
        GridData gridData = (GridData)this.getViewer().getControl().getLayoutData();
        gridData.heightHint = n;
    }

    public int getListWidth() {
        return this.listWidth;
    }

    public void setListWidth(int n) {
        this.listWidth = n;
        GridData gridData = (GridData)this.getViewer().getControl().getLayoutData();
        gridData.widthHint = n;
    }

    protected void notifyValueListeners() {
        ValueEvent valueEvent = new ValueEvent(this, this.getFieldName());
        valueEvent.setValue(this.getValue());
        this.eventDelegate.notifyValueListeners(valueEvent);
    }

    protected void setSelectedBean(BeanWrapper beanWrapper, boolean bl) {
        if (beanWrapper == null) {
            this.lastSelectionBean = null;
            return;
        }
        boolean bl2 = this.isOn();
        try {
            try {
                if (bl2) {
                    this.off();
                }
                BeanUI.beanToUI(beanWrapper.getBean(), this.editorUI);
                this.lastSelectionBean = beanWrapper;
                this.getListEditorUI().notifySelected(this);
                this.updateButtons();
                if (bl && this.listeners != null) {
                    BeanSelectionEvent beanSelectionEvent = new BeanSelectionEvent(this, this.getSelectedIndex(), this.lastSelectionBean.getBean());
                    for (BeanSelectionListener beanSelectionListener : this.listeners) {
                        beanSelectionListener.selectionChanged(beanSelectionEvent);
                    }
                }
                if (this.getNameField() != null) {
                    this.updateName(this.lastSelectionBean);
                }
                if (this.lastSelectionBean != null && this.getViewer() != null) {
                    this.getViewer().refresh((Object)this.lastSelectionBean);
                }
            }
            catch (Throwable throwable) {
                logger.error("Cannot select value", throwable);
                if (bl2) {
                    this.on();
                }
                try {
                    BeanUI.fireBoundsUpdaters(beanWrapper.getBean(), this.editorUI);
                }
                catch (Exception exception) {
                    logger.error("Cannot notify value listeners", (Throwable)exception);
                }
            }
        }
        finally {
            if (bl2) {
                this.on();
            }
            try {
                BeanUI.fireBoundsUpdaters(beanWrapper.getBean(), this.editorUI);
            }
            catch (Exception exception) {
                logger.error("Cannot notify value listeners", (Throwable)exception);
            }
        }
    }

    @Override
    protected void valueChanged(ValueEvent valueEvent) throws Exception {
        try {
            if (this.lastSelectionBean != null && valueEvent.getFieldName() != null) {
                BeanUI.uiToBean(this.editorUI, this.lastSelectionBean.getBean(), valueEvent.getFieldName());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    protected BeanWrapper getSelectedBeanWrapper() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getViewer().getSelection();
        return (BeanWrapper)iStructuredSelection.getFirstElement();
    }

    public String getSelectedBeanName() {
        BeanWrapper beanWrapper = this.getSelectedBeanWrapper();
        if (beanWrapper != null) {
            return beanWrapper.getName();
        }
        return null;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(int n) {
        this.maxItems = n;
    }

    public int getMinItems() {
        return this.minItems;
    }

    public void setMinItems(int n) {
        this.minItems = n;
    }

    protected void clear() {
        this.beans.clear();
        this.takenNames.clear();
    }

    @Override
    public void setValue(Object object) {
        List list = (List)object;
        this.clear();
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            BeanWrapper beanWrapper = new BeanWrapper(e);
            beanWrapper.setName(this.getFreeName(beanWrapper, this.getTemplateName(), n));
            this.beans.add(beanWrapper);
            ++n;
        }
    }

    protected String getFreeName(BeanWrapper beanWrapper, String string, int n) {
        if (this.getNameField() != null) {
            this.updateName(beanWrapper);
            if (beanWrapper.isValidName()) {
                this.takenNames.put(beanWrapper, beanWrapper.getName());
                return beanWrapper.getName();
            }
        }
        if (this.takenNames.containsKey(beanWrapper)) {
            return this.takenNames.get(beanWrapper);
        }
        if (n < 1) {
            n = 1;
        }
        String string2 = String.valueOf(string) + " " + n;
        if (!this.takenNames.values().contains(string2)) {
            this.takenNames.put(beanWrapper, string2);
            return string2;
        }
        String string3 = this.getFreeName(beanWrapper, string, n + 1);
        this.takenNames.put(beanWrapper, string3);
        return string3;
    }

    protected void updateName(BeanWrapper beanWrapper) {
        String string = BeansFactory.getGetterName((String)this.getNameField());
        try {
            String string2;
            Method method = beanWrapper.getBean().getClass().getMethod(string, new Class[0]);
            Object object = method.invoke(beanWrapper.getBean(), new Object[0]);
            String string3 = string2 = object != null ? object.toString() : this.getDefaultName();
            if (string2 != null) {
                beanWrapper.setName(string2);
            }
        }
        catch (Exception exception) {
            logger.error("Cannot set the name field", (Throwable)exception);
        }
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String string) {
        this.templateName = string;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public void setDefaultName(String string) {
        this.defaultName = string;
    }

    public ListEditorUI getListEditorUI() {
        if (this.listEditorUI == null) {
            this.listEditorUI = ListEditorUIAdapter.getDefault();
        }
        return this.listEditorUI;
    }

    public void setListEditorUI(ListEditorUI listEditorUI) {
        this.listEditorUI = listEditorUI;
    }
}

