/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.scalebox;

import java.text.NumberFormat;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.nfunk.jep.JEP;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.SymbolTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.beans.BeansFactory;
import uk.ac.gda.common.rcp.util.GridUtils;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.scalebox.ScaleBox;
import uk.ac.gda.richbeans.event.ValueAdapter;
import uk.ac.gda.richbeans.event.ValueEvent;

public class ScaleBoxAndFixedExpression
extends ScaleBox {
    private static Logger logger = LoggerFactory.getLogger(ScaleBoxAndFixedExpression.class);
    private Label fixedExpressionLabel;
    private JEP jepParser;
    private SymbolTable symbolTable;
    private Object dataProvider;
    private String expression;
    private String thisVariable;
    private String labelUnit;
    private String prefix;
    private ExpressionProvider provider;
    private NumberFormat labelNumberFormat;

    public ScaleBoxAndFixedExpression(Composite composite, int n) {
        super(composite, n);
        this.createFixedExpressionLabel();
    }

    public ScaleBoxAndFixedExpression(Composite composite, int n, ExpressionProvider expressionProvider) {
        super(composite, n);
        this.createFixedExpressionLabel();
        this.provider = expressionProvider;
        IFieldWidget[] iFieldWidgetArray = this.provider.getPrecedents();
        if (iFieldWidgetArray != null) {
            int n2 = 0;
            while (n2 < iFieldWidgetArray.length) {
                iFieldWidgetArray[n2].addValueListener(new ValueAdapter(){

                    @Override
                    public void valueChangePerformed(ValueEvent valueEvent) {
                        ScaleBoxAndFixedExpression.this.updateLabel();
                    }
                });
                ++n2;
            }
        }
    }

    public ScaleBoxAndFixedExpression(Composite composite, int n, String string, String string2, Object object) throws ParseException {
        super(composite, n);
        this.createFixedExpressionLabel();
        this.thisVariable = string;
        this.expression = string2;
        this.symbolTable = this.getSymbolTable(string2);
        this.dataProvider = object;
    }

    private void createFixedExpressionLabel() {
        this.createExpressionLabel(-1);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        if (this.fixedExpressionLabel != null) {
            return;
        }
        this.fixedExpressionLabel = new Label((Composite)this, 131072);
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.widthHint = 80;
        this.fixedExpressionLabel.setLayoutData((Object)gridData);
        this.layout();
    }

    public void setFixedExpressionValue(double d) {
        String string = this.getLabel(d);
        this.fixedExpressionLabel.setText(string);
        if (string == null || "".equals(string.trim()) || "-".equals(string.trim())) {
            GridUtils.setVisibleAndLayout((Control)this.fixedExpressionLabel, false);
        } else {
            GridUtils.setVisibleAndLayout((Control)this.fixedExpressionLabel, true);
        }
    }

    public void setExpressionLabelTooltip(String string) {
        this.fixedExpressionLabel.setToolTipText(string);
    }

    @Override
    protected void checkValue(String string) {
        super.checkValue(string);
        if (string == null || "".equals(string.trim()) || "-".equals(string.trim())) {
            GridUtils.setVisibleAndLayout((Control)this.fixedExpressionLabel, false);
            return;
        }
        double d = this.getNumericValue();
        this.updateLabel(d);
    }

    private void updateLabel() {
        this.updateLabel(this.getNumericValue());
    }

    private void updateLabel(double d) {
        try {
            if (this.provider == null && this.jepParser == null) {
                return;
            }
            double d2 = Double.NaN;
            if (this.provider != null) {
                d2 = this.provider.getValue(d);
            } else {
                SymbolTable symbolTable = this.symbolTable;
                Set set = symbolTable.entrySet();
                for (Map.Entry entry : set) {
                    if (entry.getValue() != null || entry.getKey().equals(this.thisVariable)) continue;
                    double d3 = (Double)BeansFactory.getBeanValue((Object)this.dataProvider, (String)entry.getKey().toString());
                    this.jepParser.addVariable(entry.getKey().toString(), d3);
                }
                this.jepParser.addVariable(this.thisVariable, d);
                this.jepParser.parseExpression(this.expression);
                d2 = this.jepParser.getValue();
            }
            this.setFixedExpressionValue(d2);
            this.layout();
        }
        catch (Exception exception) {
            logger.error("Cannot compute value " + this.expression, (Throwable)exception);
            this.fixedExpressionLabel.setText("");
        }
    }

    private String getLabel(double d) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getPrefix() != null) {
            stringBuilder.append(this.getPrefix());
            stringBuilder.append(" ");
        }
        String string = this.labelNumberFormat != null ? this.labelNumberFormat.format(d) : this.numberFormat.format(d);
        stringBuilder.append(string);
        if (this.getLabelUnit() != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.getLabelUnit());
        }
        return stringBuilder.toString();
    }

    public void setLabelDecimalPlaces(int n) {
        if (this.labelNumberFormat == null) {
            this.labelNumberFormat = NumberFormat.getInstance();
        }
        this.labelNumberFormat.setMaximumFractionDigits(n);
    }

    private SymbolTable getSymbolTable(String string) throws ParseException {
        this.jepParser = new JEP();
        this.jepParser.addStandardFunctions();
        this.jepParser.addStandardConstants();
        this.jepParser.setAllowUndeclared(true);
        this.jepParser.setImplicitMul(true);
        this.jepParser.parse(string);
        return this.jepParser.getSymbolTable();
    }

    public Object getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(Object object) {
        this.dataProvider = object;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String string) {
        this.expression = string;
    }

    public String getThisVariable() {
        return this.thisVariable;
    }

    public void setThisVariable(String string) {
        this.thisVariable = string;
    }

    public String getLabelUnit() {
        return this.labelUnit;
    }

    public void setLabelUnit(String string) {
        this.labelUnit = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public static interface ExpressionProvider {
        public double getValue(double var1);

        public IFieldWidget[] getPrecedents();
    }
}

