/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.cell;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

public class SpinnerCellEditor
extends CellEditor {
    protected Spinner spinner;
    private FocusAdapter focusListener;
    private KeyListener keyListener;
    private static final int defaultStyle = 0;

    public SpinnerCellEditor() {
        this.setStyle(0);
    }

    public SpinnerCellEditor(Composite composite) {
        this(composite, 0);
    }

    public SpinnerCellEditor(Composite composite, int n) {
        super(composite, n);
    }

    protected Control createControl(Composite composite) {
        this.spinner = new Spinner(composite, this.getStyle());
        this.spinner.setFont(composite.getFont());
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SpinnerCellEditor.this.focusLost();
            }
        };
        this.spinner.addFocusListener((FocusListener)this.focusListener);
        this.keyListener = new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.character == '\n') {
                    SpinnerCellEditor.this.focusLost();
                }
                if (keyEvent.character == '\r') {
                    SpinnerCellEditor.this.focusLost();
                }
            }
        };
        this.spinner.addKeyListener(this.keyListener);
        return this.spinner;
    }

    public void dispose() {
        if (this.focusListener != null) {
            this.spinner.removeFocusListener((FocusListener)this.focusListener);
        }
        if (this.keyListener != null) {
            this.spinner.removeKeyListener(this.keyListener);
        }
        super.dispose();
    }

    protected Object doGetValue() {
        return this.spinner.getSelection();
    }

    protected void doSetFocus() {
        this.spinner.setFocus();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.spinner == null || this.spinner.isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gC = new GC((Drawable)this.spinner);
            layoutData.minimumWidth = gC.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gC.dispose();
        }
        return layoutData;
    }

    protected void doSetValue(Object object) {
        Assert.isTrue((this.spinner != null && object instanceof Integer ? 1 : 0) != 0);
        this.spinner.setSelection(((Integer)object).intValue());
    }

    void applyEditorValueAndDeactivate() {
        Object object = this.doGetValue();
        this.markDirty();
        boolean bl = this.isCorrect(object);
        this.setValueValid(bl);
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    public void setMaximum(int n) {
        if (this.spinner != null) {
            this.spinner.setMaximum(n);
        }
    }

    public void setMinimum(int n) {
        if (this.spinner != null) {
            this.spinner.setMinimum(n);
        }
    }
}

