/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.richbeans.ACTIVE_MODE;
import uk.ac.gda.richbeans.beans.BeanProvider;
import uk.ac.gda.richbeans.beans.BeanUI;
import uk.ac.gda.richbeans.beans.IExpressionManager;
import uk.ac.gda.richbeans.beans.IExpressionWidget;
import uk.ac.gda.richbeans.beans.IFieldCollection;
import uk.ac.gda.richbeans.beans.IFieldProvider;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.FieldComposite;
import uk.ac.gda.richbeans.components.selector.BeanSelectionListener;
import uk.ac.gda.richbeans.editors.BeanExpressionManager;
import uk.ac.gda.richbeans.event.ValueAdapter;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;

public class FieldBeanComposite
extends FieldComposite
implements IFieldCollection,
IExpressionWidget,
IFieldProvider,
BeanProvider {
    private static Logger logger = LoggerFactory.getLogger(FieldBeanComposite.class);
    protected Object beanTemplate;
    protected Object editorUI;
    protected Object editorBean;
    protected String listenerName;
    protected List<String> expressionFields;
    protected boolean active = true;
    private ACTIVE_MODE activeMode = ACTIVE_MODE.SET_VISIBLE_AND_ACTIVE;
    private boolean isOn = false;
    protected Collection<BeanSelectionListener> listeners;
    private boolean isEnabled = true;

    public FieldBeanComposite(Composite composite, int n) {
        this(composite, n, FieldBeanComposite.class.getName());
        this.editorUI = this;
    }

    public FieldBeanComposite(Composite composite, int n, String string) {
        super(composite, n);
        this.listenerName = string;
        this.editorUI = this;
    }

    public void setEditorClass(Class<?> clazz) {
        try {
            this.beanTemplate = clazz.newInstance();
            if (this.editorUI == this) {
                this.addValueListeners(this);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setEditorUI(Object object) {
        this.editorUI = object;
        this.addValueListeners(this.editorUI);
    }

    public Object getEditorUI() {
        return this.editorUI;
    }

    protected void addValueListeners(Object object) {
        if (this.beanTemplate == null) {
            throw new RuntimeException("You must set the editing class for with setEditorClass(...) before setting the editorUI object.");
        }
        try {
            BeanUI.addValueListener(this.beanTemplate, object, new ValueAdapter(this.getListenerName()){

                @Override
                public void valueChangePerformed(ValueEvent valueEvent) {
                    try {
                        FieldBeanComposite.this.valueChanged(valueEvent);
                    }
                    catch (Exception exception) {
                        logger.error("Cannot process value changed.", (Throwable)exception);
                    }
                }
            });
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void valueChanged(ValueEvent valueEvent) throws Exception {
        try {
            if (valueEvent.getFieldName() != null) {
                BeanUI.uiToBean(this.editorUI, this.editorBean, valueEvent.getFieldName());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    @Override
    public void addValueListener(ValueListener valueListener) {
        if (this.editorUI == null) {
            throw new RuntimeException("You must set the editing UI for each item with setEditorUI(...)");
        }
        if (this.beanTemplate == null) {
            throw new RuntimeException("You must set the editing class for with setEditorClass(...)");
        }
        try {
            BeanUI.addValueListener(this.beanTemplate, this.editorUI, valueListener);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void removeValueListener(ValueListener valueListener) {
        if (this.editorUI == null) {
            throw new RuntimeException("You must set the editing UI for each item with setEditorUI(...)");
        }
        if (this.beanTemplate == null) {
            throw new RuntimeException("You must set the editing class for with setEditorClass(...)");
        }
        try {
            BeanUI.removeValueListener(this.beanTemplate, this.editorUI, valueListener);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void dispose() {
        block8: {
            try {
                if (this.listeners != null) {
                    this.listeners.clear();
                }
                if (this.editorUI == null || this.beanTemplate == null) break block8;
                if (this.editorUI instanceof Widget && ((Widget)this.editorUI).isDisposed()) {
                    return;
                }
                try {
                    BeanUI.dispose(this.beanTemplate, this.editorUI);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            finally {
                super.dispose();
            }
        }
    }

    @Override
    public Object getValue() {
        return this.editorBean;
    }

    @Override
    public void setValue(Object object) {
        this.editorBean = object;
        try {
            this.off();
            if (this.editorUI instanceof Widget && ((Widget)this.editorUI).isDisposed()) {
                return;
            }
            try {
                BeanUI.beanToUI(this.editorBean, this.editorUI);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        finally {
            this.on();
        }
    }

    @Override
    public void setExpressionManager(IExpressionManager iExpressionManager) {
        try {
            if (this.editorUI instanceof Widget && ((Widget)this.editorUI).isDisposed()) {
                return;
            }
            BeanUI.notify(this.editorBean, this.editorUI, new BeanUI.BeanProcessor(){

                @Override
                public void process(Map.Entry<Object, Object> entry, IFieldWidget iFieldWidget) throws Exception {
                    if (iFieldWidget instanceof IExpressionWidget) {
                        IExpressionWidget iExpressionWidget = (IExpressionWidget)iFieldWidget;
                        if (!iExpressionWidget.isExpressionAllowed()) {
                            return;
                        }
                        BeanExpressionManager beanExpressionManager = new BeanExpressionManager(iExpressionWidget, FieldBeanComposite.this);
                        beanExpressionManager.setAllowedSymbols(FieldBeanComposite.this.getExpressionFields());
                        iExpressionWidget.setExpressionManager(beanExpressionManager);
                    }
                }
            });
        }
        catch (Exception exception) {
            logger.error("Cannot link expression widgets for " + this.editorBean, (Throwable)exception);
        }
    }

    @Override
    public void setExpressionValue(final double d) {
        try {
            if (this.editorUI instanceof Widget && ((Widget)this.editorUI).isDisposed()) {
                return;
            }
            BeanUI.notify(this.editorBean, this.editorUI, new BeanUI.BeanProcessor(){

                @Override
                public void process(Map.Entry<Object, Object> entry, IFieldWidget iFieldWidget) throws Exception {
                    if (iFieldWidget instanceof IExpressionWidget) {
                        IExpressionWidget iExpressionWidget = (IExpressionWidget)iFieldWidget;
                        iExpressionWidget.setExpressionValue(d);
                    }
                }
            });
        }
        catch (Exception exception) {
            logger.error("Cannot link expression widgets for " + this.editorBean, (Throwable)exception);
        }
    }

    protected List<String> getExpressionFields() throws Exception {
        if (this.expressionFields == null) {
            this.expressionFields = BeanUI.getEditingFields(this.editorBean, this.editorUI);
        }
        return this.expressionFields;
    }

    public void setEditingBean(Object object) {
        boolean bl = this.editorBean == null;
        this.editorBean = object;
        if (bl) {
            this.setValue(object);
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
        if (this.activeMode == ACTIVE_MODE.SET_VISIBLE_AND_ACTIVE) {
            this.setVisible(bl);
        } else if (this.activeMode == ACTIVE_MODE.SET_ENABLED_AND_ACTIVE) {
            this.setVisible(bl);
        }
    }

    public ACTIVE_MODE getActiveMode() {
        return this.activeMode;
    }

    public void setActiveMode(ACTIVE_MODE aCTIVE_MODE) {
        this.activeMode = aCTIVE_MODE;
    }

    @Override
    public boolean isOn() {
        return this.isOn;
    }

    @Override
    public void off() {
        if (this.editorUI == null) {
            throw new RuntimeException("You must set the editing UI with setEditorUI(...)");
        }
        if (this.beanTemplate == null) {
            throw new RuntimeException("You must set the editing class for with setEditorClass(...)");
        }
        this.isOn = false;
        this.updateState(this.isOn);
    }

    @Override
    public void on() {
        if (this.editorUI == null) {
            throw new RuntimeException("You must set the editing UI for each item with setEditorUI(...)");
        }
        if (this.beanTemplate == null) {
            throw new RuntimeException("You must set the editing class for with setEditorClass(...)");
        }
        this.isOn = true;
        this.updateState(this.isOn);
    }

    protected void updateState(boolean bl) {
        try {
            BeanUI.switchState(this.beanTemplate, this.editorUI, bl);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void addBeanSelectionListener(BeanSelectionListener beanSelectionListener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<BeanSelectionListener>(7);
        }
        this.listeners.add(beanSelectionListener);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
        try {
            BeanUI.setEnabled(this.beanTemplate, this.editorUI, bl);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getListenerName() {
        return this.listenerName;
    }

    public void setListenerName(String string) {
        this.listenerName = string;
    }

    @Override
    public Object getBean() {
        return this.editorBean;
    }

    @Override
    public Object getInstance() throws Exception {
        return this.beanTemplate.getClass().newInstance();
    }

    @Override
    public IFieldWidget getField(String string) throws Exception {
        return BeanUI.getFieldWiget(string, this.editorUI);
    }

    @Override
    public Object getFieldValue(String string) throws Exception {
        return this.getField(string).getValue();
    }

    @Override
    public Control getControl() {
        return null;
    }

    @Override
    public boolean isExpressionParseRequired(String string) {
        return true;
    }

    @Override
    public boolean isExpressionAllowed() {
        return true;
    }
}

