/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.beans;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.beanutils.BeanUtils;
import uk.ac.gda.beans.BeansFactory;
import uk.ac.gda.richbeans.beans.IFieldCollection;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.event.ValueListener;

public class BeanUI {
    private static Map<String, IFieldWidget> cachedWidgets;
    private static Map<String, Collection<ValueListener>> waitingListeners;

    public static void beanToUI(Object object, Object object2) throws Exception {
        BeanUI.notify(object, object2, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> entry, IFieldWidget iFieldWidget) throws Exception {
                Object object = entry.getValue();
                iFieldWidget.setFieldName(entry.getKey().toString());
                if (object == null && !iFieldWidget.isActive()) {
                    return;
                }
                iFieldWidget.setValue(object);
            }
        });
    }

    public static void fireValueListeners(Object object, Object object2) throws Exception {
        BeanUI.notify(object, object2, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> entry, IFieldWidget iFieldWidget) throws Exception {
                iFieldWidget.fireValueListeners();
            }
        });
    }

    public static void fireBoundsUpdaters(Object object, Object object2) throws Exception {
        BeanUI.notify(object, object2, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> entry, IFieldWidget iFieldWidget) throws Exception {
                iFieldWidget.fireBoundsUpdaters();
            }
        });
    }

    public static void uiToBean(Object object, Object object2) throws Exception {
        BeanUI.notify(object2, object, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> entry, IFieldWidget iFieldWidget) throws Exception {
                try {
                    if (!(iFieldWidget instanceof IFieldCollection)) {
                        entry.setValue(null);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (!iFieldWidget.isActive()) {
                    return;
                }
                Object object = iFieldWidget.getValue();
                if (!(object == null || "".equals(object) || BeanUI.isNaN(object) || BeanUI.isInfinity(object))) {
                    entry.setValue(object);
                }
            }
        });
    }

    public static void uiToBean(Object object, Object object2, String string) throws Exception {
        if (string == null) {
            throw new Exception("Null fieldName passed to uiToBean. Please set the field name.");
        }
        IFieldWidget iFieldWidget = BeanUI.getFieldWiget(string, object);
        if (iFieldWidget == null) {
            return;
        }
        if (!iFieldWidget.isActive()) {
            return;
        }
        Object object3 = iFieldWidget.getValue();
        if (!(object3 == null || "".equals(object3) || BeanUI.isNaN(object3) || BeanUI.isInfinity(object3))) {
            BeansFactory.setBeanValue((Object)object2, (String)string, (Object)object3);
        } else if (object3 != null) {
            Method method = object2.getClass().getMethod(BeansFactory.getSetterName((String)string), object3.getClass());
            method.invoke(object2, object3.getClass().cast(null));
        }
    }

    private static boolean isInfinity(Object object) {
        if (!(object instanceof Double)) {
            return false;
        }
        return Double.isInfinite((Double)object);
    }

    private static boolean isNaN(Object object) {
        if (!(object instanceof Double)) {
            return false;
        }
        return Double.isNaN((Double)object);
    }

    public static void addValueListener(Object object, Object object2, final ValueListener valueListener) throws Exception {
        BeanUI.notify(object, object2, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> entry, IFieldWidget iFieldWidget) throws Exception {
                iFieldWidget.addValueListener(valueListener);
            }
        });
    }

    public static void removeValueListener(Object object, Object object2, final ValueListener valueListener) throws Exception {
        BeanUI.notify(object, object2, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> entry, IFieldWidget iFieldWidget) throws Exception {
                iFieldWidget.removeValueListener(valueListener);
            }
        });
    }

    public static void setBeanFields(final Object object, Object object2) throws Exception {
        BeanUI.notify(object, object2, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> entry, IFieldWidget iFieldWidget) throws Exception {
                BeanUI.addBeanField(object.getClass(), entry.getKey().toString(), iFieldWidget);
            }
        });
    }

    public static void addBeanField(Class<? extends Object> clazz, String string, IFieldWidget iFieldWidget) {
        Collection<ValueListener> collection;
        string = String.valueOf(string.substring(0, 1).toLowerCase(Locale.US)) + string.substring(1);
        if (cachedWidgets == null) {
            cachedWidgets = new ConcurrentHashMap<String, IFieldWidget>(89);
        }
        String string2 = String.valueOf(clazz.getName()) + ":" + string;
        cachedWidgets.put(string2, iFieldWidget);
        if (waitingListeners != null && (collection = waitingListeners.get(string2)) != null) {
            for (ValueListener valueListener : collection) {
                iFieldWidget.addValueListener(valueListener);
            }
            waitingListeners.remove(string2);
        }
    }

    public static void addBeanFieldValueListener(Class<? extends Object> clazz, String string, ValueListener valueListener) throws Exception {
        IFieldWidget iFieldWidget;
        string = String.valueOf(string.substring(0, 1).toLowerCase(Locale.US)) + string.substring(1);
        String string2 = String.valueOf(clazz.getName()) + ":" + string;
        IFieldWidget iFieldWidget2 = iFieldWidget = cachedWidgets != null ? cachedWidgets.get(string2) : null;
        if (iFieldWidget == null) {
            Collection<ValueListener> collection;
            if (waitingListeners == null) {
                waitingListeners = new ConcurrentHashMap<String, Collection<ValueListener>>(31);
            }
            if ((collection = waitingListeners.get(string2)) == null) {
                collection = new HashSet<ValueListener>(3);
                waitingListeners.put(string2, collection);
            }
            collection.add(valueListener);
            return;
        }
        iFieldWidget.addValueListener(valueListener);
    }

    public static IFieldWidget getBeanField(String string, Class<? extends Object> ... classArray) {
        string = String.valueOf(string.substring(0, 1).toLowerCase(Locale.US)) + string.substring(1);
        int n = 0;
        while (n < classArray.length) {
            IFieldWidget iFieldWidget;
            String string2 = String.valueOf(classArray[n].getName()) + ":" + string;
            IFieldWidget iFieldWidget2 = iFieldWidget = cachedWidgets != null ? cachedWidgets.get(string2) : null;
            if (iFieldWidget != null) {
                return iFieldWidget;
            }
            ++n;
        }
        return null;
    }

    public static void switchState(Object object, Object object2, final boolean bl) throws Exception {
        BeanUI.notify(object, object2, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> entry, IFieldWidget iFieldWidget) {
                if (bl) {
                    iFieldWidget.on();
                } else {
                    iFieldWidget.off();
                }
            }
        });
    }

    public static void switchState(Object object, boolean bl) throws Exception {
        Method[] methodArray = object.getClass().getMethods();
        int n = 0;
        while (n < methodArray.length) {
            Object object2;
            Method method = methodArray[n];
            if (method.getReturnType() != null && method.getName().startsWith("get") && (object2 = method.invoke(object, new Object[0])) != null && object2 instanceof IFieldWidget) {
                IFieldWidget iFieldWidget = (IFieldWidget)object2;
                if (bl) {
                    iFieldWidget.on();
                } else {
                    iFieldWidget.off();
                }
            }
            ++n;
        }
    }

    public static void setEnabled(Object object, Object object2, final boolean bl) throws Exception {
        BeanUI.notify(object, object2, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> entry, IFieldWidget iFieldWidget) {
                iFieldWidget.setEnabled(bl);
            }
        });
    }

    public static void dispose(Object object, Object object2) throws Exception {
        BeanUI.notify(object, object2, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> entry, IFieldWidget iFieldWidget) {
                iFieldWidget.dispose();
            }
        });
    }

    public static final void notify(Object object, Object object2, BeanProcessor beanProcessor) throws Exception {
        BeanMap beanMap = new BeanMap(object);
        Iterator iterator = beanMap.entryIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            try {
                IFieldWidget iFieldWidget;
                String string = entry.getKey().toString();
                if (string.equals("class") || (iFieldWidget = BeanUI.getFieldWiget(string, object2)) == null) continue;
                beanProcessor.process(entry, iFieldWidget);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
    }

    public static IFieldWidget getFieldWiget(String string, Object object) throws Exception {
        String string2 = BeansFactory.getGetterName((String)string);
        Method method = object.getClass().getMethod(string2, new Class[0]);
        Object object2 = method.invoke(object, new Object[0]);
        return object2 instanceof IFieldWidget ? (IFieldWidget)object2 : null;
    }

    public static List<?> cloneBeans(List<?> list) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (Object obj : list) {
            arrayList.add(BeansFactory.deepClone(obj));
        }
        return arrayList;
    }

    public static List<String> getEditingFields(Object object, Object object2) throws Exception {
        Set set = BeanUtils.describe((Object)object).keySet();
        ArrayList<String> arrayList = new ArrayList<String>(set);
        arrayList.remove("class");
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                IFieldWidget iFieldWidget = BeanUI.getFieldWiget(string, object2);
                if (iFieldWidget != null) continue;
                iterator.remove();
            }
            catch (Exception exception) {
                iterator.remove();
            }
        }
        return arrayList;
    }

    public static interface BeanProcessor {
        public void process(Map.Entry<Object, Object> var1, IFieldWidget var2) throws Exception;
    }
}

