/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.common.rcp.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class IFileUtils {
    public static StringBuilder readFile(IFile iFile) throws Exception {
        BufferedReader bufferedReader = null;
        try {
            int n;
            bufferedReader = new BufferedReader(new InputStreamReader(iFile.getContents(), iFile.getCharset()));
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[4096];
            while ((n = bufferedReader.read(cArray, 0, 4096)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
            StringBuilder stringBuilder2 = stringBuilder;
            return stringBuilder2;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public static List<String> parseFile(IFile iFile) throws Exception {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(iFile.getContents(), iFile.getCharset()));
            ArrayList<String> arrayList = new ArrayList<String>(89);
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public static void saveFile(IFile iFile, List<String> list) throws Exception {
        BufferedWriter bufferedWriter = null;
        try {
            PipedInputStream pipedInputStream = new PipedInputStream();
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)pipedOutputStream, iFile.getCharset()));
            for (String string : list) {
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
            iFile.setContents((InputStream)pipedInputStream, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    public static long getLength(IResource iResource) throws Exception {
        if (!iResource.exists()) {
            return 0L;
        }
        return EFS.getStore((URI)iResource.getLocationURI()).fetchInfo().getLength();
    }

    public static long getLastModified(IResource iResource) throws Exception {
        if (!iResource.exists()) {
            return 0L;
        }
        if (iResource instanceof IFile) {
            ((IFile)iResource).getLocalTimeStamp();
        }
        return EFS.getStore((URI)iResource.getLocationURI()).fetchInfo().getLastModified();
    }

    public static void createLinks(IFolder iFolder, Path path, IProgressMonitor iProgressMonitor) throws CoreException {
        IPath iPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        File file = path.toFile();
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            if (!file2.isHidden() && file2.isDirectory()) {
                Path path2 = new Path(file2.getAbsolutePath());
                IFolder iFolder2 = iFolder.getFolder(path2.lastSegment());
                if (path2.isPrefixOf(iPath)) {
                    iFolder2.create(false, true, iProgressMonitor);
                    IFileUtils.createLinks(iFolder2, path2, iProgressMonitor);
                } else {
                    iFolder2.createLink((IPath)path2, 2, iProgressMonitor);
                }
            }
            ++n;
        }
    }
}

