/*
 * Decompiled with CFR 0.152.
 */
package swing2swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import swing2swt.layout.AWTLayout;

public class BorderLayout
extends AWTLayout {
    public static final String CENTER = "Center";
    public static final String EAST = "East";
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String WEST = "West";
    private int hgap;
    private int vgap;
    private Control centerChild;
    private Control eastChild;
    private Control northChild;
    private Control southChild;
    private Control westChild;

    public BorderLayout() {
    }

    public BorderLayout(int n, int n2) {
        this.hgap = n;
        this.vgap = n2;
    }

    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        Point point;
        this.readLayoutData(composite);
        Point point2 = new Point(0, 0);
        if (this.northChild != null) {
            point = this.getPreferredSize(this.northChild, n, -1, bl);
            point2.y += point.y + this.vgap;
        }
        if (this.southChild != null) {
            point = this.getPreferredSize(this.southChild, n, -1, bl);
            point2.y += point.y + this.vgap;
        }
        if (this.westChild != null) {
            point = this.getPreferredSize(this.westChild, -1, n2, bl);
            point2.x += point.x + this.hgap;
        }
        if (this.eastChild != null) {
            point = this.getPreferredSize(this.eastChild, -1, n2, bl);
            point2.x += point.x + this.hgap;
        }
        if (this.centerChild != null) {
            point = this.getPreferredSize(this.centerChild, n, n2, bl);
            point2.x += point.x;
            point2.y += point.y;
        }
        return point2;
    }

    protected void layout(Composite composite, boolean bl) {
        Point point;
        this.readLayoutData(composite);
        Rectangle rectangle = composite.getClientArea();
        int n = rectangle.y;
        int n2 = rectangle.y + rectangle.height;
        int n3 = rectangle.x;
        int n4 = rectangle.x + rectangle.width;
        if (this.northChild != null) {
            point = this.getPreferredSize(this.northChild, rectangle.width, -1, bl);
            this.northChild.setBounds(n3, n, n4 - n3, point.y);
            n += point.y + this.vgap;
        }
        if (this.southChild != null) {
            point = this.getPreferredSize(this.southChild, rectangle.width, -1, bl);
            this.southChild.setBounds(n3, n2 - point.y, n4 - n3, point.y);
            n2 -= point.y + this.vgap;
        }
        if (this.westChild != null) {
            point = this.getPreferredSize(this.westChild, -1, n2 - n, bl);
            this.westChild.setBounds(n3, n, point.x, n2 - n);
            n3 += point.x + this.hgap;
        }
        if (this.eastChild != null) {
            point = this.getPreferredSize(this.eastChild, -1, n2 - n, bl);
            this.eastChild.setBounds(n4 - point.x, n, point.x, n2 - n);
            n4 -= point.x + this.hgap;
        }
        if (this.centerChild != null) {
            this.centerChild.setBounds(n3, n, n4 - n3, n2 - n);
        }
    }

    private void readLayoutData(Composite composite) {
        this.centerChild = null;
        this.westChild = null;
        this.eastChild = null;
        this.southChild = null;
        this.northChild = null;
        Control[] controlArray = composite.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Object object = controlArray[n].getLayoutData();
            if (NORTH.equals(object)) {
                this.northChild = controlArray[n];
            } else if (SOUTH.equals(object)) {
                this.southChild = controlArray[n];
            } else if (EAST.equals(object)) {
                this.eastChild = controlArray[n];
            } else if (WEST.equals(object)) {
                this.westChild = controlArray[n];
            } else {
                this.centerChild = controlArray[n];
            }
            ++n;
        }
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }
}

