/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.beans.exafs.b18;

import java.util.List;
import junit.framework.TestCase;
import org.junit.Test;
import uk.ac.gda.beans.exafs.b18.B18SampleParameters;
import uk.ac.gda.beans.exafs.b18.FurnaceParameters;
import uk.ac.gda.beans.exafs.b18.LN2CryostatParameters;
import uk.ac.gda.beans.exafs.b18.PulseTubeCryostatParameters;
import uk.ac.gda.beans.exafs.b18.SmallLN2CryostatParameters;
import uk.ac.gda.beans.exafs.b18.XYThetaStageParameters;
import uk.ac.gda.doe.DOEUtils;

public class B18SampleParametersTest
extends TestCase {
    public static B18SampleParameters createTestParameters() {
        PulseTubeCryostatParameters pulseTubeCryostatParameters = new PulseTubeCryostatParameters();
        pulseTubeCryostatParameters.setTemperature(-50.0);
        pulseTubeCryostatParameters.setTolerance(1.0);
        pulseTubeCryostatParameters.setTime(60.0);
        pulseTubeCryostatParameters.setSampleNumber(2);
        FurnaceParameters furnaceParameters = new FurnaceParameters();
        furnaceParameters.setTemperature(-50.0);
        furnaceParameters.setTolerance(1.0);
        furnaceParameters.setTime(60.0);
        furnaceParameters.setGastype("N");
        LN2CryostatParameters lN2CryostatParameters = new LN2CryostatParameters();
        lN2CryostatParameters.setTemperature(-50.0);
        lN2CryostatParameters.setTolerance(1.0);
        lN2CryostatParameters.setTime(60.0);
        lN2CryostatParameters.setSampleNumber("2");
        lN2CryostatParameters.setFirstSampleAngle(0.0);
        lN2CryostatParameters.setFirstSampleHeight(10.0);
        lN2CryostatParameters.setCylinderType("fluo");
        SmallLN2CryostatParameters smallLN2CryostatParameters = new SmallLN2CryostatParameters();
        smallLN2CryostatParameters.setTemperature(-50.0);
        smallLN2CryostatParameters.setTolerance(1.0);
        smallLN2CryostatParameters.setTime(60.0);
        XYThetaStageParameters xYThetaStageParameters = new XYThetaStageParameters();
        xYThetaStageParameters.setX(0.0);
        xYThetaStageParameters.setY(0.0);
        xYThetaStageParameters.setTheta(0.0);
        B18SampleParameters b18SampleParameters = new B18SampleParameters();
        b18SampleParameters.setXYThetaStageParameters(xYThetaStageParameters);
        b18SampleParameters.setSmallLN2CryostatParameters(smallLN2CryostatParameters);
        b18SampleParameters.setLN2CryostatParameters(lN2CryostatParameters);
        b18SampleParameters.setFurnaceParameters(furnaceParameters);
        b18SampleParameters.setPulseTubeCryostatParameters(pulseTubeCryostatParameters);
        b18SampleParameters.setShouldValidate(true);
        return b18SampleParameters;
    }

    @Test
    public void testDOEExpansion() {
        try {
            List list = DOEUtils.expand((Object)B18SampleParametersTest.createTestParameters());
            B18SampleParametersTest.assertEquals((int)1, (int)list.size());
        }
        catch (Exception exception) {
            B18SampleParametersTest.fail((String)exception.getMessage());
        }
    }

    @Test
    public void testLimitedDOEExpansion() {
        try {
            B18SampleParameters b18SampleParameters = B18SampleParametersTest.createTestParameters();
            b18SampleParameters.setStage("xythetastage");
            b18SampleParameters.setTemperatureControl("pulsetubecryostat");
            List list = DOEUtils.expand((Object)b18SampleParameters);
            B18SampleParametersTest.assertEquals((int)1, (int)list.size());
        }
        catch (Exception exception) {
            B18SampleParametersTest.fail((String)exception.getMessage());
        }
    }
}

