/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.beans.exafs;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import uk.ac.gda.beans.exafs.IOutputParameters;
import uk.ac.gda.beans.exafs.SignalParameters;
import uk.ac.gda.util.beans.xml.XMLHelpers;

public class OutputParameters
implements Serializable,
IOutputParameters {
    private String asciiFileName;
    private String asciiDirectory;
    private String nexusDirectory;
    private List<SignalParameters> signalList = new ArrayList<SignalParameters>();
    private boolean signalActive;
    private boolean shouldValidate = true;
    private boolean extraData = false;
    public static final URL mappingURL = OutputParameters.class.getResource("ExafsParameterMapping.xml");
    public static final URL schemaUrl = OutputParameters.class.getResource("ExafsParameterMapping.xsd");

    public boolean isSignalActive() {
        return this.signalActive;
    }

    public void setSignalActive(boolean bl) {
        this.signalActive = bl;
    }

    public void clear() {
        this.signalList.clear();
    }

    public static OutputParameters createFromXML(String string) throws Exception {
        return (OutputParameters)XMLHelpers.createFromXML((URL)mappingURL, OutputParameters.class, (URL)schemaUrl, (String)string);
    }

    public static void writeToXML(OutputParameters outputParameters, String string) throws Exception {
        XMLHelpers.writeToXML((URL)mappingURL, (Object)outputParameters, (String)string);
    }

    @Override
    public String getAsciiFileName() {
        return this.asciiFileName;
    }

    public void setAsciiFileName(String string) {
        this.asciiFileName = string;
    }

    @Override
    public String getAsciiDirectory() {
        return this.asciiDirectory;
    }

    public void setAsciiDirectory(String string) {
        this.asciiDirectory = string;
    }

    public String getNexusDirectory() {
        return this.nexusDirectory;
    }

    public void setNexusDirectory(String string) {
        this.nexusDirectory = string;
    }

    public void addSignal(SignalParameters signalParameters) {
        this.signalList.add(signalParameters);
    }

    public List<SignalParameters> getSignalList() {
        return this.signalList;
    }

    public List<SignalParameters> getCheckedSignalList() {
        return this.signalActive ? this.getSignalList() : Collections.EMPTY_LIST;
    }

    public void setSignalList(List<SignalParameters> list) {
        this.signalList = list;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.asciiDirectory == null ? 0 : this.asciiDirectory.hashCode());
        n = 31 * n + (this.asciiFileName == null ? 0 : this.asciiFileName.hashCode());
        n = 31 * n + (this.extraData ? 1231 : 1237);
        n = 31 * n + (this.nexusDirectory == null ? 0 : this.nexusDirectory.hashCode());
        n = 31 * n + (this.shouldValidate ? 1231 : 1237);
        n = 31 * n + (this.signalActive ? 1231 : 1237);
        n = 31 * n + (this.signalList == null ? 0 : this.signalList.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OutputParameters outputParameters = (OutputParameters)object;
        if (this.asciiDirectory == null ? outputParameters.asciiDirectory != null : !this.asciiDirectory.equals(outputParameters.asciiDirectory)) {
            return false;
        }
        if (this.asciiFileName == null ? outputParameters.asciiFileName != null : !this.asciiFileName.equals(outputParameters.asciiFileName)) {
            return false;
        }
        if (this.extraData != outputParameters.extraData) {
            return false;
        }
        if (this.nexusDirectory == null ? outputParameters.nexusDirectory != null : !this.nexusDirectory.equals(outputParameters.nexusDirectory)) {
            return false;
        }
        if (this.shouldValidate != outputParameters.shouldValidate) {
            return false;
        }
        if (this.signalActive != outputParameters.signalActive) {
            return false;
        }
        return !(this.signalList == null ? outputParameters.signalList != null : !this.signalList.equals(outputParameters.signalList));
    }

    public String toString() {
        try {
            return BeanUtils.describe((Object)this).toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public boolean isShouldValidate() {
        return this.shouldValidate;
    }

    public void setShouldValidate(boolean bl) {
        this.shouldValidate = bl;
    }

    public boolean isExtraData() {
        return this.extraData;
    }

    public void setExtraData(boolean bl) {
        this.extraData = bl;
    }
}

