/*
 * Decompiled with CFR 0.152.
 */
package org.edna.passerelle.common.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ModelUtils {
    public static void createEmptyWorkflow(IContainer iContainer, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IFile iFile = iContainer.getFile((IPath)new Path(string));
        iFile.create(ModelUtils.openContentStream(), true, iProgressMonitor);
    }

    private static InputStream openContentStream() {
        String string = "<?xml version=\"1.0\" standalone=\"no\"?> \r\n<!DOCTYPE entity PUBLIC \"-//UC Berkeley//DTD MoML 1//EN\" \"http://ptolemy.eecs.berkeley.edu/xml/dtd/MoML_1.dtd\"> \r\n<entity name=\"newModel\" class=\"ptolemy.actor.TypedCompositeActor\"> \r\n   <property name=\"_createdBy\" class=\"ptolemy.kernel.attributes.VersionAttribute\" value=\"7.0.1\" /> \r\n   <property name=\"Director\" class=\"com.isencia.passerelle.domain.cap.Director\" > \r\n      <property name=\"_location\" class=\"ptolemy.kernel.util.Location\" value=\"{20, 20}\" /> \r\n   </property> \r\n</entity>";
        return new ByteArrayInputStream(string.getBytes());
    }

    public static IProject createPasserelleProject(String string, IWorkspaceRoot iWorkspaceRoot, IProgressMonitor iProgressMonitor) throws Exception {
        IProject iProject = iWorkspaceRoot.getProject(string);
        iProject.create(iProgressMonitor);
        iProject.open(iProgressMonitor);
        ModelUtils.createEmptyWorkflow((IContainer)iProject, "empty_workflow.moml", iProgressMonitor);
        ModelUtils.createClasspathWorkflow((IContainer)iProject, "example_workflow.moml", iProgressMonitor);
        return iProject;
    }

    public static void createClasspathWorkflow(IContainer iContainer, String string, IProgressMonitor iProgressMonitor) throws Exception {
        Bundle bundle = Platform.getBundle((String)"org.edna.passerelle.common");
        URL uRL = bundle.getResource(string);
        IFile iFile = iContainer.getFile((IPath)new Path(string));
        iFile.create(uRL.openStream(), true, iProgressMonitor);
    }
}

