/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Sleak {
    Display display;
    Shell shell;
    List list;
    Canvas canvas;
    Button start;
    Button stop;
    Button check;
    Text text;
    Label label;
    Object[] oldObjects = new Object[0];
    Error[] oldErrors = new Error[0];
    Object[] objects = new Object[0];
    Error[] errors = new Error[0];

    public void open() {
        this.display = Display.getCurrent();
        this.shell = new Shell(this.display);
        this.shell.setText("S-Leak");
        this.list = new List((Composite)this.shell, 2560);
        this.list.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Sleak.this.refreshObject();
            }
        });
        this.text = new Text((Composite)this.shell, 2816);
        this.canvas = new Canvas((Composite)this.shell, 2048);
        this.canvas.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                Sleak.this.paintCanvas(event);
            }
        });
        this.check = new Button((Composite)this.shell, 32);
        this.check.setText("Stack");
        this.check.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Sleak.this.toggleStackTrace();
            }
        });
        this.start = new Button((Composite)this.shell, 8);
        this.start.setText("Snap");
        this.start.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Sleak.this.refreshAll();
            }
        });
        this.stop = new Button((Composite)this.shell, 8);
        this.stop.setText("Diff");
        this.stop.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Sleak.this.refreshDifference();
            }
        });
        this.label = new Label((Composite)this.shell, 2048);
        this.label.setText("0 object(s)");
        this.shell.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Sleak.this.layout();
            }
        });
        this.check.setSelection(false);
        this.text.setVisible(false);
        Point point = this.shell.getSize();
        this.shell.setSize(point.x / 2, point.y / 2);
        this.shell.open();
    }

    void refreshLabel() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < this.objects.length) {
            Object object = this.objects[n7];
            if (object instanceof Color) {
                ++n;
            }
            if (object instanceof Cursor) {
                ++n2;
            }
            if (object instanceof Font) {
                ++n3;
            }
            if (object instanceof GC) {
                ++n4;
            }
            if (object instanceof Image) {
                ++n5;
            }
            if (object instanceof Region) {
                ++n6;
            }
            ++n7;
        }
        String string = "";
        if (n != 0) {
            string = String.valueOf(string) + n + " Color(s)\n";
        }
        if (n2 != 0) {
            string = String.valueOf(string) + n2 + " Cursor(s)\n";
        }
        if (n3 != 0) {
            string = String.valueOf(string) + n3 + " Font(s)\n";
        }
        if (n4 != 0) {
            string = String.valueOf(string) + n4 + " GC(s)\n";
        }
        if (n5 != 0) {
            string = String.valueOf(string) + n5 + " Image(s)\n";
        }
        if (string.length() != 0) {
            string = string.substring(0, string.length() - 1);
        }
        this.label.setText(string);
    }

    void refreshDifference() {
        MessageBox messageBox;
        DeviceData deviceData = this.display.getDeviceData();
        if (!deviceData.tracking) {
            messageBox = new MessageBox(this.shell, 40);
            messageBox.setText(this.shell.getText());
            messageBox.setMessage("Warning: Device is not tracking resource allocation");
            messageBox.open();
        }
        messageBox = deviceData.objects;
        Error[] errorArray = deviceData.errors;
        Object[] objectArray = new Object[((MessageBox)messageBox).length];
        Error[] errorArray2 = new Error[errorArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < ((MessageBox)messageBox).length) {
            int n3 = 0;
            while (n3 < this.oldObjects.length) {
                if (messageBox[n2] == this.oldObjects[n3]) break;
                ++n3;
            }
            if (n3 == this.oldObjects.length) {
                objectArray[n] = messageBox[n2];
                errorArray2[n] = errorArray[n2];
                ++n;
            }
            ++n2;
        }
        this.objects = new Object[n];
        this.errors = new Error[n];
        System.arraycopy(objectArray, 0, this.objects, 0, n);
        System.arraycopy(errorArray2, 0, this.errors, 0, n);
        this.list.removeAll();
        this.text.setText("");
        this.canvas.redraw();
        n2 = 0;
        while (n2 < this.objects.length) {
            this.list.add(this.objectName(this.objects[n2]));
            ++n2;
        }
        this.refreshLabel();
        this.layout();
    }

    String objectName(Object object) {
        String string = object.toString();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    void toggleStackTrace() {
        this.refreshObject();
        this.layout();
    }

    void paintCanvas(Event event) {
        this.canvas.setCursor(null);
        int n = this.list.getSelectionIndex();
        if (n == -1) {
            return;
        }
        GC gC = event.gc;
        Object object = this.objects[n];
        if (object instanceof Color) {
            if (((Color)object).isDisposed()) {
                return;
            }
            gC.setBackground((Color)object);
            gC.fillRectangle(this.canvas.getClientArea());
            return;
        }
        if (object instanceof Cursor) {
            if (((Cursor)object).isDisposed()) {
                return;
            }
            this.canvas.setCursor((Cursor)object);
            return;
        }
        if (object instanceof Font) {
            if (((Font)object).isDisposed()) {
                return;
            }
            gC.setFont((Font)object);
            FontData[] fontDataArray = gC.getFont().getFontData();
            String string = "";
            String string2 = this.text.getLineDelimiter();
            int n2 = 0;
            while (n2 < fontDataArray.length) {
                FontData fontData = fontDataArray[n2];
                String string3 = "NORMAL";
                int n3 = fontData.getStyle();
                if (n3 != 0) {
                    if ((n3 & 1) != 0) {
                        string3 = "BOLD ";
                    }
                    if ((n3 & 2) != 0) {
                        string3 = String.valueOf(string3) + "ITALIC";
                    }
                }
                string = String.valueOf(string) + fontData.getName() + " " + fontData.getHeight() + " " + string3 + string2;
                ++n2;
            }
            gC.drawString(string, 0, 0);
            return;
        }
        if (object instanceof Image) {
            if (((Image)object).isDisposed()) {
                return;
            }
            gC.drawImage((Image)object, 0, 0);
            return;
        }
        if (object instanceof Region) {
            if (((Region)object).isDisposed()) {
                return;
            }
            String string = ((Region)object).getBounds().toString();
            gC.drawString(string, 0, 0);
            return;
        }
    }

    void refreshObject() {
        int n = this.list.getSelectionIndex();
        if (n == -1) {
            return;
        }
        if (this.check.getSelection()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            this.errors[n].printStackTrace(printStream);
            this.text.setText(byteArrayOutputStream.toString());
            this.text.setVisible(true);
            this.canvas.setVisible(false);
        } else {
            this.canvas.setVisible(true);
            this.text.setVisible(false);
            this.canvas.redraw();
        }
    }

    void refreshAll() {
        this.oldObjects = new Object[0];
        this.oldErrors = new Error[0];
        this.refreshDifference();
        this.oldObjects = this.objects;
        this.oldErrors = this.errors;
    }

    void layout() {
        Rectangle rectangle = this.shell.getClientArea();
        String[] cfr_ignored_0 = new String[this.objects.length];
        int n = 0;
        String[] stringArray = this.list.getItems();
        GC gC = new GC((Drawable)this.list);
        int n2 = 0;
        while (n2 < this.objects.length) {
            n = Math.max(n, gC.stringExtent((String)stringArray[n2]).x);
            ++n2;
        }
        gC.dispose();
        Point point = this.start.computeSize(-1, -1);
        Point point2 = this.stop.computeSize(-1, -1);
        Point point3 = this.check.computeSize(-1, -1);
        Point point4 = this.label.computeSize(-1, -1);
        n = Math.max(point.x, Math.max(point2.x, Math.max(point3.x, n)));
        n = Math.max(64, Math.max(point4.x, this.list.computeSize((int)n, (int)-1).x));
        this.start.setBounds(0, 0, n, point.y);
        this.stop.setBounds(0, point.y, n, point2.y);
        this.check.setBounds(0, point.y + point2.y, n, point3.y);
        this.label.setBounds(0, rectangle.height - point4.y, n, point4.y);
        int n3 = point.y + point2.y + point3.y;
        this.list.setBounds(0, n3, n, rectangle.height - n3 - point4.y);
        this.text.setBounds(n, 0, rectangle.width - n, rectangle.height);
        this.canvas.setBounds(n, 0, rectangle.width - n, rectangle.height);
    }

    public static void main(String[] stringArray) {
        Display display = new Display();
        Sleak sleak = new Sleak();
        sleak.open();
        while (!sleak.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

