/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.beans;

import de.jtem.beans.AbstractDialog;
import de.jtem.beans.EditorSpawner;
import de.jtem.beans.SymmetricShapeChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.Collections;
import java.util.Map;

public class SymmetricShapeEditor
extends EditorSpawner {
    private static boolean allowNullByDefault;

    public SymmetricShapeEditor() {
        this(allowNullByDefault);
    }

    public SymmetricShapeEditor(boolean withNullOption) {
        super(withNullOption);
    }

    public AbstractDialog getDialog() {
        return SymmetricShapeChooser.sharedInstance();
    }

    protected void paintEditedObject(Component cmp, Graphics g, int x, int y) {
        Map<RenderingHints.Key, Object> hints = Collections.singletonMap(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.getValue() != null) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.black);
            g2d.addRenderingHints(hints);
            g2d.translate(x + this.getIconWidth() / 2, y + this.getIconHeight() / 2);
            g2d.fill((Shape)this.getValue());
            g2d.translate(-(x + this.getIconWidth() / 2), -(y + this.getIconHeight() / 2));
        }
    }

    public boolean accept(Component c, Object o) {
        return SymmetricShapeChooser.sharedInstance().accept(c, o);
    }

    public static boolean isAllowNullByDefault() {
        return allowNullByDefault;
    }

    public static void setAllowNullByDefault(boolean allowNullByDefault) {
        SymmetricShapeEditor.allowNullByDefault = allowNullByDefault;
    }

    public static class WithNullOption
    extends SymmetricShapeEditor {
        public WithNullOption() {
            super(true);
        }
    }
}

