/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.beans;

import de.jtem.beans.AbstractDialog;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SymmetricShapeChooser
extends AbstractDialog {
    private static final long serialVersionUID = 3389775807616984946L;
    private static SymmetricShapeChooser sharedInstance;
    private JComboBox box = new JComboBox();
    private boolean updating = false;
    private SpinnerNumberModel radiusModel = new SpinnerNumberModel(new Double(1.0), new Double(0.0), null, new Double(1.0));

    public SymmetricShapeChooser() {
        Box column = new Box(1);
        this.box.addItem("circle");
        this.box.addItem("square");
        this.box.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent arg0) {
                if (!SymmetricShapeChooser.this.updating) {
                    SymmetricShapeChooser.this.fireStateChanged();
                }
            }
        });
        column.add(this.box);
        this.radiusModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                if (!SymmetricShapeChooser.this.updating) {
                    SymmetricShapeChooser.this.fireStateChanged();
                }
            }
        });
        Box row = new Box(0);
        JLabel label = new JLabel("radius");
        label.setBorder(new EmptyBorder(0, 0, 0, 5));
        row.add(label);
        row.add(new JSpinner(this.radiusModel));
        row.setBorder(new EmptyBorder(5, 0, 5, 0));
        column.add(row);
        this.setMainComponent(column);
        this.pack();
    }

    public Object getValue() {
        double r = this.radiusModel.getNumber().doubleValue();
        if (this.box.getSelectedItem().equals("circle")) {
            return new Ellipse2D.Double(-r, -r, 2.0 * r, 2.0 * r);
        }
        return new Rectangle2D.Double(-r, -r, 2.0 * r, 2.0 * r);
    }

    public void setValue(Object s) {
        this.updating = true;
        if (s instanceof RectangularShape && SymmetricShapeChooser.isSymmetric((RectangularShape)s)) {
            double r = ((RectangularShape)s).getWidth() / 2.0;
            this.radiusModel.setValue(new Double(r));
            if (s instanceof Rectangle2D.Double) {
                this.box.setSelectedItem("square");
            } else {
                this.box.setSelectedItem("circle");
            }
        }
        this.updating = false;
    }

    public static SymmetricShapeChooser sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new SymmetricShapeChooser();
        }
        return sharedInstance;
    }

    public boolean accept(Component c, Object s) {
        boolean accepted = false;
        if (s != null) {
            if (s instanceof Ellipse2D.Double || s instanceof Rectangle2D.Double) {
                RectangularShape r = (RectangularShape)s;
                accepted = SymmetricShapeChooser.isSymmetric(r);
            }
            if (!accepted) {
                int decision = JOptionPane.showConfirmDialog(c, "Proceeding will replace the present shape of type " + s.getClass().getName() + " with a circle or a sqare. Do you really want this?", "Warning", 2);
                accepted = decision == 0;
            }
        } else {
            accepted = true;
        }
        return accepted;
    }

    private static boolean isSymmetric(RectangularShape s) {
        return s.getCenterX() == 0.0 && s.getCenterY() == 0.0 && s.getHeight() == s.getWidth();
    }
}

