/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.beans;

import de.jtem.beans.AbstractDialog;
import de.jtem.beans.ChoiceEditor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StrokeDialog
extends AbstractDialog
implements PropertyChangeListener,
ActionListener,
ChangeListener {
    private static final long serialVersionUID = -5046164637730760157L;
    public static StrokeDialog instance = null;
    boolean updating = false;
    private BasicStroke stroke;
    private JSpinner widthSP = new JSpinner(new SpinnerNumberModel(0.0, 0.0, Double.MAX_VALUE, 1.0));
    private JSpinner miterSP = new JSpinner(new SpinnerNumberModel(0.0, 0.0, Double.MAX_VALUE, 1.0));
    private JSpinner dashPhaseSP = new JSpinner(new SpinnerNumberModel(0.0, 0.0, Double.MAX_VALUE, 1.0));
    private ChoiceEditor join = new ChoiceEditor(){

        protected void defineValuesToStrings() {
            this.valuesToStrings.put(new Integer(2), "bevel");
            this.valuesToStrings.put(new Integer(0), "miter");
            this.valuesToStrings.put(new Integer(1), "round");
        }
    };
    ChoiceEditor cap = new ChoiceEditor(){

        protected void defineValuesToStrings() {
            this.valuesToStrings.put(new Integer(0), "butt");
            this.valuesToStrings.put(new Integer(1), "round");
            this.valuesToStrings.put(new Integer(2), "square");
        }
    };
    private JTextField dashArrayTF;

    private StrokeDialog(String title, BasicStroke stroke) {
        this.setTitle(title);
        Box chooserPanel = new Box(1);
        JPanel chooser = new JPanel(new GridBagLayout());
        chooser.setPreferredSize(new Dimension(300, 150));
        if (stroke == null) {
            stroke = new BasicStroke();
        }
        this.stroke = stroke;
        GridBagConstraints label = new GridBagConstraints();
        label.anchor = 13;
        label.ipadx = 3;
        GridBagConstraints editor = new GridBagConstraints();
        editor.fill = 1;
        editor.anchor = 10;
        editor.weightx = 1.0;
        editor.gridwidth = 0;
        GridBagConstraints preview = new GridBagConstraints();
        preview.gridwidth = 0;
        preview.gridheight = 0;
        preview.fill = 1;
        this.widthSP.addChangeListener(this);
        chooser.add((Component)new JLabel("line width  "), label);
        chooser.add((Component)this.widthSP, editor);
        chooser.add((Component)new JLabel("end cap  "), label);
        this.cap.addPropertyChangeListener(this);
        chooser.add(this.cap.getCustomEditor(), editor);
        chooser.add((Component)new JLabel("line join  "), label);
        this.join.addPropertyChangeListener(this);
        chooser.add(this.join.getCustomEditor(), editor);
        this.miterSP.addChangeListener(this);
        chooser.add((Component)new JLabel("miter limit  "), label);
        chooser.add((Component)this.miterSP, editor);
        chooser.add((Component)new JLabel("dash array  "), label);
        this.dashArrayTF = new JTextField();
        this.dashArrayTF.addActionListener(this);
        chooser.add((Component)this.dashArrayTF, editor);
        chooser.add((Component)new JLabel("dash phase  "), label);
        this.dashPhaseSP.addChangeListener(this);
        this.dashPhaseSP.setEnabled(stroke.getDashArray() != null && stroke.getDashArray().length > 0);
        chooser.add((Component)this.dashPhaseSP, editor);
        JPanel previewPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                StrokeDialog.this.paintStroke((Graphics2D)g);
            }
        };
        previewPanel.setPreferredSize(new Dimension(300, 200));
        previewPanel.setBackground(Color.white);
        chooserPanel.add(chooser);
        chooserPanel.add((Component)previewPanel, preview);
        this.setMainComponent(chooserPanel);
        this.setValue(stroke);
        this.pack();
    }

    public static StrokeDialog sharedInstance() {
        if (instance == null) {
            instance = new StrokeDialog("Choose Stroke", new BasicStroke());
        }
        return instance;
    }

    public BasicStroke getValue() {
        return this.stroke;
    }

    public void paintStroke(Graphics2D g2) {
        g2.setStroke(this.stroke);
        g2.drawPolyline(new int[]{50, 250, 50, 250}, new int[]{50, 50, 150, 150}, 4);
    }

    private String dashArrayToString(float[] dashArray) {
        String s = "";
        if (dashArray == null) {
            return s;
        }
        for (int i = 0; i < dashArray.length - 1; ++i) {
            s = s + dashArray[i] + ",";
        }
        if (dashArray.length > 0) {
            s = s + dashArray[dashArray.length - 1];
        }
        return s;
    }

    public void setValue(Object s) {
        this.updating = true;
        this.stroke = s instanceof BasicStroke ? (BasicStroke)s : new BasicStroke();
        this.widthSP.setValue(new Double(this.stroke.getLineWidth()));
        this.miterSP.setValue(new Double(this.stroke.getMiterLimit()));
        this.dashArrayTF.setText(this.dashArrayToString(this.stroke.getDashArray()));
        this.cap.setValue(new Integer(this.stroke.getEndCap()));
        this.join.setValue(new Integer(this.stroke.getLineJoin()));
        this.updating = false;
    }

    public void stateChanged(ChangeEvent e) {
        if (!this.updating) {
            Object s = e.getSource();
            if (s == this.widthSP) {
                float w = ((Double)this.widthSP.getValue()).floatValue();
                this.stroke = new BasicStroke(w, this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
            } else if (s == this.miterSP) {
                float w = ((Double)this.miterSP.getValue()).floatValue();
                this.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), this.stroke.getLineJoin(), w, this.stroke.getDashArray(), this.stroke.getDashPhase());
            } else if (s == this.dashPhaseSP) {
                float w = ((Double)this.dashPhaseSP.getValue()).floatValue();
                this.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), w);
            }
            this.repaint();
            this.fireStateChanged();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.updating) {
            StringTokenizer st;
            String daS = this.dashArrayTF.getText().trim();
            String cont = "";
            float[] da = null;
            if (daS.length() > 0 && (st = new StringTokenizer(daS, ",")).countTokens() > 0) {
                int i;
                da = new float[st.countTokens()];
                for (i = 0; i < da.length; ++i) {
                    da[i] = Float.parseFloat(st.nextToken());
                }
                for (i = 0; i < da.length - 1; ++i) {
                    cont = cont + da[i] + ",";
                }
                cont = cont + da[da.length - 1];
            }
            this.dashArrayTF.setText(cont);
            this.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), da, this.stroke.getDashPhase());
            this.dashPhaseSP.setEnabled(cont.length() != 0);
            this.repaint();
            this.fireStateChanged();
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (!this.updating) {
            Object source = e.getSource();
            if (source == this.cap) {
                this.stroke = new BasicStroke(this.stroke.getLineWidth(), (Integer)this.cap.getValue(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
            } else if (source == this.join) {
                this.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), (Integer)this.join.getValue(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
            }
            this.repaint();
            this.fireStateChanged();
        }
    }
}

