/*
 * Decompiled with CFR 0.152.
 */
package org.edna.common.readers.edf;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;

public class EDF_Reader {
    private static final String ESRF_READER_VERSION = "November 2001";
    String[] types = new String[]{"EDF", "EHF"};
    String[] typesDescription = new String[]{"ESRF Data Format", "ESRF data Header Format"};
    private boolean intelByteOrder = false;

    private void parseESRFDataFormatHeader(String string, File file) {
        String string2;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            int n = 0;
            int n2 = 0;
            do {
                int n3 = n;
                randomAccessFile.seek(n3);
                do {
                    char c = this.getChar(randomAccessFile);
                    ++n;
                    if (c == '{') {
                        ++n2;
                        continue;
                    }
                    if (c != '}') continue;
                    --n2;
                } while (n2 != 0);
                byte[] byArray = new byte[n - n3 + 1];
                randomAccessFile.seek(n3);
                randomAccessFile.readFully(byArray);
                string2 = new String(byArray);
            } while (string.equals("EHF") && string2.indexOf("EDF_DataBlockID") < 0);
        }
        catch (IOException iOException) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf("=");
            if (n <= 0) continue;
            String string4 = string3.substring(1, n - 1).trim();
            String string5 = string3.substring(n + 1).trim();
            try {
                Integer.valueOf(string5).intValue();
                Integer.valueOf(string5).doubleValue();
            }
            catch (NumberFormatException numberFormatException) {}
            if (string4.equals("EDF_BinaryFileName")) {
                System.out.println("DEBUG: " + string4 + " = " + string5);
                continue;
            }
            if (string4.equals("EDF_BinaryFilePosition") || string4.equals("Dim_1") || string4.equals("Dim_2")) continue;
            if (string4.equals("DataType")) {
                if (string5.equals("UnsignedLong") || string5.equals("UnsignedInteger") || string5.equals("UnsignedShort") || string5.equals("Float") || string5.equals("FloatValue") || string5.equals("UnsignedByte") || string5.equals("UnsignedChar")) continue;
                string5.equals("SignedShort");
                continue;
            }
            string4.equals("ByteOrder");
        }
    }

    int getShort(RandomAccessFile randomAccessFile) throws IOException {
        int n = randomAccessFile.read();
        int n2 = randomAccessFile.read();
        if (this.intelByteOrder) {
            return (n2 << 8) + n;
        }
        return (n << 8) + n2;
    }

    char getChar(RandomAccessFile randomAccessFile) throws IOException {
        int n = randomAccessFile.read();
        return (char)n;
    }

    void showAbout() {
        String string = "This plugin reads image formats commonly used the ESRF.\nIt can currently read the following formats:\n \n";
        int n = 0;
        while (n < this.types.length) {
            string = String.valueOf(string) + this.types[n] + ":   " + this.typesDescription[n] + "\n";
            ++n;
        }
        string = String.valueOf(string) + " \nThis plugin is written and maintained by Olof Svensson, ESRF.\nPlease send suggestions or bug reports to svensson@esrf.fr.\n \nPetr Mikulik (mikulik@physics.muni.cz) has contributed code to\nthe EFD/EDH format header reader.\n \nThis is version November 2001\n";
    }
}

