'''
Region of interest package

Classes available:
    line is a linear ROI
    rect is a rectangular ROI
    sect is a sector ROI
    roilist is a list of ROIs

'''

import uk.ac.diamond.scisoft.analysis.roi as _roi
import scisoftpy as _np

from scisoftpy import ndarraywrapped as _npwrapped

_asDs = _np.asDataset

line = _roi.LinearROI

rect = _roi.RectangularROI
sect = _roi.SectorROI

roilist = _roi.ROIList

@_npwrapped
def profile(data, roi, step=None, mask=None):
    '''Calculate a profile with given roi (a step value is required for a linear ROI)
    mask is used when clipping compensation is set true (for rectangular and sector ROI)
    '''
    data = _asDs(data)
    if isinstance(roi, line):
        if step == None:
            raise ValueError, "step value required"
        return _roi.ROIProfileIDataset.line(data, roi, step)
    if isinstance(roi, rect):
        if mask == None:
            return _roi.ROIProfileIDataset.box(data, roi)
        else:
            return _roi.ROIProfileIDataset.box(data, mask, roi)
    if isinstance(roi, sect):
        if mask == None:
            return _roi.ROIProfileIDataset.sector(data, roi)
        else:
            return _roi.ROIProfileIDataset.sector(data, mask, roi)
    raise ValueError, "roi is not of known type"

