'''
Random number generator package
'''

import uk.ac.diamond.scisoft.analysis.dataset.Random as _random

from scisoftpy import ndarraywrapped as _npwrapped
from scisoftpy import asIterable as _asiter

@_npwrapped
def rand(shape=None):
    '''Return dataset of given shape (or a single number) with samples taken
    from a uniform distribution between 0 and 1
    '''
    if shape == None:
        return _random.rand([1]).getObject([0])
    return _random.rand(_asiter(shape))

@_npwrapped
def randn(shape=None):
    '''Return dataset of given shape (or a single number) with samples taken
    from a normal distribution of zero mean and unit variance
    '''
    if shape == None:
        return _random.randn([1]).getObject([0])
    return _random.randn(_asiter(shape))

def randint(low, high=None, shape=None):
    '''Return dataset of given shape (or a single number) with samples taken
    from a discrete distribution of integers in the range [low, high)
    '''
    if high == None:
        high = low
        low = 0
    return random_integers(low, high-1, shape)

@_npwrapped
def random_integers(low, high=None, shape=None):
    '''Return dataset of given shape (or a single number) with samples taken
    from a discrete distribution of integers in the range [low, high]
    '''
    if high == None:
        high = low
        low = 0
    if shape == None:
        return _random.random_integers(low, high, [1]).getObject([0])
    return _random.random_integers(low, high, _asiter(shape))

@_npwrapped
def exponential(scale=1.0, shape=None):
    '''Return dataset of given shape (or a single number) with samples taken
    from an exponential distribution of parameter scale
    '''
    if shape == None:
        return _random.exponential(scale, [1]).getObject([0])
    return _random.exponential(scale, _asiter(shape))

@_npwrapped
def poisson(lam=1.0, shape=None):
    '''Return dataset of given shape (or a single number) with samples taken
    from a Poisson distribution of parameter lam
    '''
    if shape == None:
        return _random.poisson(lam, [1]).getObject([0])
    return _random.poisson(lam, _asiter(shape))

def seed(seed=None):
    '''Set seed to given value (or a value based on the current time in
    milliseconds since the Epoch)
    '''
    if seed == None:
        import time
        seed = int(time.time()*1000)
    _random.seed(seed)
