'''
Test random class
import unittest
unittest.TestProgram(argv=["io_test"])
'''
import unittest

#import scisoftpy as dnp
import scisoftpy.io as dio

Testfolder = "../../testfiles/images/"

class Test(unittest.TestCase):
    def load(self, name, testfolder=Testfolder):
        path = testfolder + name
        im = dio.load(path)
        print type(im[0]), im[0].shape

    def colourload(self, name, testfolder=Testfolder):
        path = testfolder + name
        im = dio.load(path, ascolour=True)
        print type(im[0]), im[0].shape
        return im[0]

    def testLoading(self):
        import os
        print os.getcwd()
        self.load("test.png")
        self.load("testrgb.png")

        self.colourload("test.png")
        im = self.colourload("testrgb.png")
        print 'slicing RGB: ', type(im.getSlice((slice(5),2))), type(im[:5,2])

        self.load("test.jpg")
        self.load("testlossy85.jpg")
        self.load("testrgb.jpg")
        self.load("testrgblossy85.jpg")

        self.colourload("test.jpg")
        self.colourload("testrgb.jpg")
        self.colourload("testrgblossy85.jpg")

        self.load("test.tiff")
        self.load("test-df.tiff")
        self.load("test-pb.tiff")
        self.load("testrgb.tiff")
        self.load("testrgb-df.tiff")
        self.load("testrgb-lzw.tiff")
        self.load("testrgb-pb.tiff")

        self.colourload("testrgb.tiff")
        self.colourload("testrgb-df.tiff")
        self.colourload("testrgb-lzw.tiff")
        self.colourload("testrgb-pb.tiff")

        self.load("96356.dat", "../../testfiles/gda/analysis/io/SRSLoaderTest/")

if __name__ == "__main__":
    #import sys;sys.argv = ['', 'Test.testName']
    unittest.main()
