/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.views.run;

import com.swtdesigner.SWTResourceManager;
import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.part.ViewPart;
import uk.ac.gda.ui.views.run.AbstractScanController;
import uk.ac.gda.ui.views.run.ControllerCreatedEvent;
import uk.ac.gda.ui.views.run.ControllerCreatedListener;
import uk.ac.gda.ui.views.run.ControllerStatusEvent;
import uk.ac.gda.ui.views.run.ControllerStatusListener;
import uk.ac.gda.ui.views.run.ExperimentObject;
import uk.ac.gda.ui.views.run.ExperimentStatus;

public class QueueView
extends ViewPart
implements ControllerStatusListener {
    public static final String ID = "org.diamond.ui.views.run.QueueView";
    private TableViewer tableViewer;
    protected boolean isEnabled = false;

    public void createPartControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FillLayout());
        Table table = new Table(composite2, 101124);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setEnabled(false);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setUseHashlookup(true);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 16384, 0);
        tableViewerColumn.getColumn().setText("Name");
        tableViewerColumn.getColumn().setWidth(220);
        TableViewerColumn tableViewerColumn2 = new TableViewerColumn(this.tableViewer, 16384, 1);
        tableViewerColumn2.getColumn().setText("Status");
        tableViewerColumn2.getColumn().setWidth(200);
        TableViewerColumn tableViewerColumn3 = new TableViewerColumn(this.tableViewer, 16384, 2);
        tableViewerColumn3.getColumn().setText("Repetition");
        tableViewerColumn3.getColumn().setWidth(200);
        TableViewerColumn tableViewerColumn4 = new TableViewerColumn(this.tableViewer, 16384, 3);
        tableViewerColumn4.getColumn().setText("Percent Complete");
        tableViewerColumn4.getColumn().setWidth(200);
        new TableViewerColumn(this.tableViewer, 16384, 4);
        tableViewerColumn4.getColumn().setText("Message");
        tableViewerColumn4.getColumn().setWidth(200);
        this.tableViewer.setContentProvider((IContentProvider)this.getTableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setInput(new Object());
        this.createRightClickMenu();
        if (AbstractScanController.getInstance() == null) {
            AbstractScanController.addControllerCreatedListener(new ControllerCreatedListener(){

                @Override
                public void controllerCreated(ControllerCreatedEvent controllerCreatedEvent) {
                    ((AbstractScanController)controllerCreatedEvent.getSource()).addControllerStatusListener(QueueView.this);
                    AbstractScanController.removeControllerCreatedListener(this);
                }
            });
        } else {
            AbstractScanController.getInstance().addControllerStatusListener(this);
        }
    }

    public void dispose() {
        super.dispose();
        AbstractScanController.getInstance().removeControllerStatusListener(this);
        if (this.getSite().getSelectionProvider() != null) {
            ((Viewer)this.getSite().getSelectionProvider()).getControl().dispose();
        }
    }

    protected IStructuredContentProvider getTableContentProvider() {
        return new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                AbstractScanController abstractScanController = AbstractScanController.getInstance();
                if (abstractScanController == null) {
                    QueueView.this.isEnabled = false;
                    return new Object[]{""};
                }
                List<ExperimentObject> list = abstractScanController.getCurrentQueue();
                if (list.size() > 0) {
                    QueueView.this.isEnabled = true;
                    return list.toArray();
                }
                QueueView.this.isEnabled = false;
                return new Object[]{""};
            }
        };
    }

    private void createRightClickMenu() {
        MenuManager menuManager = new MenuManager();
        this.tableViewer.getControl().setMenu(menuManager.createContextMenu(this.tableViewer.getControl()));
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.tableViewer);
    }

    public void setFocus() {
        if (!this.tableViewer.getControl().isDisposed()) {
            this.tableViewer.getTable().setFocus();
        }
    }

    @Override
    public void statusChangePerformed(ControllerStatusEvent controllerStatusEvent) {
        this.tableViewer.refresh();
        this.tableViewer.getTable().setEnabled(this.isEnabled);
    }

    public ExperimentObject getSelected() {
        StructuredSelection structuredSelection = (StructuredSelection)this.tableViewer.getSelection();
        if (structuredSelection == null) {
            return null;
        }
        return (ExperimentObject)structuredSelection.getFirstElement();
    }

    private class TableLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private final Image runFileIcon = SWTResourceManager.getImage(QueueView.class, "/chart_line.png");

        private TableLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return n == 0 ? this.runFileIcon : null;
        }

        public String getColumnText(Object object, int n) {
            if (!(object instanceof ExperimentObject)) {
                return null;
            }
            ExperimentObject experimentObject = (ExperimentObject)object;
            switch (n) {
                case 0: {
                    return experimentObject.getName();
                }
                case 1: {
                    ExperimentStatus experimentStatus = experimentObject.getExperimentStatus();
                    return experimentStatus != null ? experimentStatus.getSuggestedLabel() : "-";
                }
                case 2: {
                    int n2 = experimentObject.getRepetition();
                    return n2 > 0 ? String.valueOf(n2) + " of " + experimentObject.getNumberRepetitions() : "";
                }
                case 3: {
                    int n3 = experimentObject.getPercentComplete();
                    return n3 > 0 ? String.valueOf(n3) + " %" : "";
                }
                case 4: {
                    String string = experimentObject.getMessage();
                    return string != null ? string : "";
                }
            }
            return null;
        }
    }
}

