/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.views.run;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.ui.views.run.AbstractScanController;
import uk.ac.gda.ui.views.run.ExperimentException;
import uk.ac.gda.ui.views.run.ExperimentObject;
import uk.ac.gda.ui.views.run.ExperimentStatus;

public abstract class ExperimentQueue<E extends ExperimentObject>
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(ExperimentQueue.class);
    protected final AbstractScanController controller;
    protected final BlockingDeque<E> queueList;
    protected final ReentrantLock lock;
    protected final Map<String, E> cloneCache;
    private E currentRun;

    protected ExperimentQueue(AbstractScanController abstractScanController) {
        this.controller = abstractScanController;
        this.queueList = new LinkedBlockingDeque(31);
        this.lock = new ReentrantLock();
        this.cloneCache = new HashMap<String, E>(7);
    }

    @Override
    public void run() {
        try {
            while (true) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                this.hold();
                try {
                    this.consume((ExperimentObject)this.queueList.take());
                }
                catch (ExperimentException experimentException) {
                    if (!experimentException.getRun().isAborted()) {
                        experimentException.getRun().setExperimentStatus(ExperimentStatus.ABORTED);
                        this.controller.showErrorMessage(experimentException);
                    }
                    this.clear();
                    this.controller.doStop();
                }
                if (!this.queueList.isEmpty()) continue;
                this.controller.doStop();
            }
        }
        catch (InterruptedException interruptedException) {
            this.currentRun = null;
            logger.debug(String.valueOf(Thread.currentThread().getName()) + " has been stopped and runs cannot be processed.");
            this.fireControllerStatusListeners();
            return;
        }
    }

    protected void clear() {
        this.lock.lock();
        try {
            if (this.currentRun != null) {
                ((ExperimentObject)this.currentRun).setExperimentStatus(ExperimentStatus.ABORTED);
            }
            Iterator<E> iterator = this.queueList.iterator();
            while (iterator.hasNext()) {
                ExperimentObject experimentObject = (ExperimentObject)iterator.next();
                experimentObject.setExperimentStatus(ExperimentStatus.READY_TO_RUN);
                iterator.remove();
            }
            this.cloneCache.clear();
        }
        finally {
            this.currentRun = null;
            this.lock.unlock();
        }
    }

    public void add(List<E> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.lock.lock();
        try {
            for (ExperimentObject experimentObject : list) {
                experimentObject.setExperimentStatus(ExperimentStatus.QUEUED);
                experimentObject.setPercentComplete(0);
                this.queueList.add(experimentObject);
                this.cloneCache.remove(experimentObject.getId());
            }
            this.fireControllerStatusListeners();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void add(E e) {
        this.lock.lock();
        try {
            ((ExperimentObject)e).setExperimentStatus(ExperimentStatus.QUEUED);
            ((ExperimentObject)e).setPercentComplete(0);
            this.queueList.add(e);
            this.cloneCache.remove(((ExperimentObject)e).getId());
            this.fireControllerStatusListeners();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove(E e) {
        this.lock.lock();
        try {
            ((ExperimentObject)e).setExperimentStatus(ExperimentStatus.READY_TO_RUN);
            ((ExperimentObject)e).setPercentComplete(0);
            this.queueList.remove(e);
            this.fireControllerStatusListeners();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove(List<E> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.setPaused(false);
        this.lock.lock();
        try {
            if (this.currentRun != null) {
                ((ExperimentObject)this.currentRun).setExperimentStatus(ExperimentStatus.ABORTED);
                this.stop(this.currentRun);
            }
            this.queueList.removeAll(list);
            for (ExperimentObject experimentObject : list) {
                if (experimentObject.getExperimentStatus() != ExperimentStatus.QUEUED) continue;
                experimentObject.setExperimentStatus(ExperimentStatus.READY_TO_RUN);
            }
            this.fireControllerStatusListeners();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void fireControllerStatusListeners() {
        this.controller.fireControllerStatusListeners();
    }

    public void moveBack(List<E> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.lock.lock();
        try {
            E e = this.getCurrentRun();
            if (e != null) {
                ((ExperimentObject)e).setExperimentStatus(ExperimentStatus.SKIPPED);
                this.stop(this.currentRun);
                this.queueList.addFirst(e);
            }
            int n = this.indexOf(list, e);
            ExperimentObject experimentObject = null;
            int n2 = n - 1;
            if (n > -1 && n < list.size()) {
                experimentObject = (ExperimentObject)list.get(n2);
            }
            if (experimentObject != null) {
                experimentObject.setExperimentStatus(ExperimentStatus.QUEUED);
                this.setQueued(n2 + 2, list);
                this.queueList.addFirst(experimentObject);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void moveForward(List<E> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.lock.lock();
        try {
            E e = this.getCurrentRun();
            if (e != null) {
                ((ExperimentObject)e).setExperimentStatus(ExperimentStatus.SKIPPED);
                this.stop(this.currentRun);
            }
            int n = this.indexOf(list, e);
            int n2 = n + 1;
            if (n > -1 && n < list.size()) {
                this.setQueued(n2, list);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private int indexOf(List<E> list, E e) {
        int n = 0;
        while (n < list.size()) {
            ExperimentObject experimentObject = (ExperimentObject)list.get(n);
            if (experimentObject.equals(e)) {
                return n;
            }
            if (experimentObject.getId().equals(((ExperimentObject)e).getCloneId())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected void setQueued(int n, List<E> list) {
        int n2 = n;
        while (n2 < list.size()) {
            ExperimentObject experimentObject = (ExperimentObject)list.get(n2);
            if (!this.contains(experimentObject)) {
                this.queueList.add(experimentObject);
            }
            experimentObject.setExperimentStatus(ExperimentStatus.QUEUED);
            ++n2;
        }
    }

    protected E getCurrentRun() {
        return (E)(this.currentRun != null ? this.currentRun : (ExperimentObject)this.queueList.peek());
    }

    protected void consume(E e) throws ExperimentException {
        try {
            ExperimentObject experimentObject = ((ExperimentObject)e).clone();
            this.cloneCache.put(((ExperimentObject)e).getId(), experimentObject);
            this.currentRun = experimentObject;
            this.hold();
            if (experimentObject.isAborted()) {
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new RuntimeException("Queue Thread Restarted");
            }
            this.controller.setSelected(experimentObject);
            experimentObject.setExperimentStatus(ExperimentStatus.RUNNING);
            experimentObject.setPercentComplete(1);
            experimentObject.setRepetition(1);
            this.fireControllerStatusListeners();
            int n = 1;
            while (n <= experimentObject.getNumberRepetitions()) {
                experimentObject.setRepetition(n);
                this.hold();
                if (experimentObject.isAborted() || experimentObject.isSkipped()) {
                    return;
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new RuntimeException("Queue Thread Restarted");
                }
                this.fireControllerStatusListeners();
                if (!this.process(experimentObject)) {
                    experimentObject.setExperimentStatus(ExperimentStatus.INVALID);
                    this.fireControllerStatusListeners();
                    return;
                }
                ++n;
            }
            this.hold();
            experimentObject.setPercentComplete(100);
            if (experimentObject.isRunning()) {
                experimentObject.setExperimentStatus(ExperimentStatus.FINISHED);
            }
        }
        finally {
            this.currentRun = null;
            this.fireControllerStatusListeners();
        }
    }

    protected abstract boolean process(E var1) throws ExperimentException;

    protected abstract void pause(E var1, boolean var2);

    protected abstract void stop(E var1);

    public void setPaused(boolean bl) {
        if (bl) {
            this.lock.lock();
            E e = this.getCurrentRun();
            if (e != null) {
                ((ExperimentObject)e).setExperimentStatus(ExperimentStatus.PAUSED);
            }
            if (e != null) {
                this.pause(e, true);
            }
        } else {
            try {
                E e = this.getCurrentRun();
                if (e != null) {
                    ((ExperimentObject)e).setExperimentStatus(ExperimentStatus.RUNNING);
                }
                if (e != null) {
                    this.pause(e, false);
                }
                this.lock.unlock();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {}
        }
    }

    public int getQueueSize() {
        return this.queueList.size();
    }

    public boolean contains(E e) {
        return this.queueList.contains(e);
    }

    private void hold() {
        try {
            this.lock.lock();
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<E> getCurrentQueue() {
        ArrayList<E> arrayList = new ArrayList<E>(this.queueList.size() + 1);
        if (this.currentRun != null) {
            arrayList.add(this.currentRun);
        }
        arrayList.addAll(this.queueList);
        return arrayList;
    }

    public boolean isEmpty() {
        return this.queueList.isEmpty();
    }

    public E getPreviouslyRun(E e) {
        if (this.currentRun != null && ((ExperimentObject)e).getId().equals(((ExperimentObject)this.currentRun).getCloneId())) {
            return null;
        }
        if (this.queueList.contains(e)) {
            return null;
        }
        return (E)((ExperimentObject)this.cloneCache.get(((ExperimentObject)e).getId()));
    }
}

