/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.views.run;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.common.rcp.util.EclipseUtils;
import uk.ac.gda.ui.views.run.ControllerCreatedEvent;
import uk.ac.gda.ui.views.run.ControllerCreatedListener;
import uk.ac.gda.ui.views.run.ControllerStatus;
import uk.ac.gda.ui.views.run.ControllerStatusEvent;
import uk.ac.gda.ui.views.run.ControllerStatusListener;
import uk.ac.gda.ui.views.run.ExperimentException;
import uk.ac.gda.ui.views.run.ExperimentObject;
import uk.ac.gda.ui.views.run.ExperimentQueue;
import uk.ac.gda.ui.views.run.ExperimentStatus;

public abstract class AbstractScanController {
    private static Logger logger = LoggerFactory.getLogger(AbstractScanController.class);
    protected final ExperimentQueue<ExperimentObject> queue;
    protected ControllerStatus state = ControllerStatus.INACTIVE;
    protected Thread queueThread;
    protected static AbstractScanController staticInstance;
    private static Collection<ControllerCreatedListener> creationListeners;
    protected Collection<ControllerStatusListener> listeners;

    public static AbstractScanController getInstance() {
        return staticInstance;
    }

    public static void addControllerCreatedListener(ControllerCreatedListener controllerCreatedListener) {
        if (creationListeners == null) {
            creationListeners = new HashSet<ControllerCreatedListener>(3);
        }
        creationListeners.add(controllerCreatedListener);
    }

    private static void fireControllerCreatedListeners(ControllerCreatedEvent controllerCreatedEvent) {
        if (creationListeners == null) {
            return;
        }
        for (ControllerCreatedListener controllerCreatedListener : creationListeners) {
            controllerCreatedListener.controllerCreated(controllerCreatedEvent);
        }
    }

    public static void removeControllerCreatedListener(ControllerCreatedListener controllerCreatedListener) {
        if (creationListeners == null) {
            creationListeners = new HashSet<ControllerCreatedListener>(3);
        }
        creationListeners.remove(controllerCreatedListener);
    }

    protected AbstractScanController() {
        this.queue = this.createQueue();
        this.createQueueThread();
        AbstractScanController.fireControllerCreatedListeners(new ControllerCreatedEvent(this));
    }

    private void createQueueThread() {
        this.queueThread = Executors.defaultThreadFactory().newThread(this.queue);
        this.queueThread.setName("Submission Queue Thread " + this.getClass().getName());
        this.queueThread.start();
    }

    public void doClear() {
        try {
            this.doStop();
            ExperimentObject experimentObject = this.queue.getCurrentRun();
            if (experimentObject != null) {
                experimentObject.setExperimentStatus(ExperimentStatus.ABORTED);
            }
        }
        finally {
            this.queue.clear();
        }
    }

    public void doBack() {
        this.setState(ControllerStatus.PLAYING);
        this.queue.moveBack(this.getRuns());
    }

    public void doForward() {
        this.setState(ControllerStatus.PLAYING);
        this.queue.moveForward(this.getRuns());
    }

    public void doPause() {
        if (this.getState() != ControllerStatus.PAUSED) {
            this.setState(ControllerStatus.PAUSED);
            this.queue.setPaused(true);
        } else {
            this.setState(ControllerStatus.PLAYING);
            this.queue.setPaused(false);
        }
        this.fireControllerStatusListeners();
    }

    public void setPaused(boolean bl) {
        if (bl && this.getState() == ControllerStatus.PAUSED) {
            return;
        }
        this.queue.setPaused(bl);
    }

    public void doRun() {
        this.saveEditors();
        this.setState(ControllerStatus.PLAYING);
        this.queue.add((ExperimentObject)((Object)this.getRuns()));
    }

    public void run(List<? extends ExperimentObject> list) {
        this.saveEditors();
        this.setState(ControllerStatus.PLAYING);
        ArrayList<? extends ExperimentObject> arrayList = new ArrayList<ExperimentObject>(list.size());
        arrayList.addAll(list);
        this.queue.add((ExperimentObject)((Object)arrayList));
    }

    public void run(ExperimentObject experimentObject) {
        this.saveEditors();
        this.setState(ControllerStatus.PLAYING);
        this.queue.add(experimentObject);
    }

    protected void saveEditors() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(false);
        }
        catch (Exception exception) {
            logger.error("Cannot save editors prior to running scan.", (Throwable)exception);
            logger.error("Scan will continue.");
        }
    }

    public void remove(ExperimentObject experimentObject) {
        if (experimentObject == null) {
            return;
        }
        this.queue.remove(experimentObject);
    }

    public void doStop() {
        this.setState(ControllerStatus.INACTIVE);
        this.queue.remove(this.getRuns());
        this.queue.stop(null);
    }

    protected abstract List<ExperimentObject> getRuns();

    protected abstract ExperimentQueue<ExperimentObject> createQueue();

    public void setSelected(Object object) {
    }

    public void addControllerStatusListener(ControllerStatusListener controllerStatusListener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<ControllerStatusListener>(7);
        }
        this.listeners.add(controllerStatusListener);
    }

    public void removeControllerStatusListener(ControllerStatusListener controllerStatusListener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<ControllerStatusListener>(7);
        }
        this.listeners.remove(controllerStatusListener);
    }

    public void fireControllerStatusListeners() {
        if (this.listeners == null) {
            return;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        ExperimentObject experimentObject = this.queue.getCurrentRun();
        if (experimentObject == null && this.queue.isEmpty()) {
            this.setState(ControllerStatus.INACTIVE);
        }
        final ControllerStatusEvent controllerStatusEvent = new ControllerStatusEvent(this, experimentObject);
        controllerStatusEvent.setState(this.getState());
        for (final ControllerStatusListener controllerStatusListener : this.listeners) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        controllerStatusListener.statusChangePerformed(controllerStatusEvent);
                    }
                    catch (Exception exception) {
                        logger.error("Cannot set statusChangePerformed on " + controllerStatusListener, (Throwable)exception);
                    }
                }
            });
        }
    }

    public boolean isRunning() {
        return this.getState() == ControllerStatus.PLAYING || this.getState() == ControllerStatus.PAUSED;
    }

    public ControllerStatus getState() {
        return this.state;
    }

    public void setState(ControllerStatus controllerStatus) {
        this.state = controllerStatus;
    }

    public void showErrorMessage(final ExperimentException experimentException) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                if (experimentException.isMultipleErrors()) {
                    try {
                        EclipseUtils.getActivePage().showView("org.eclipse.ui.views.ProblemView");
                    }
                    catch (PartInitException partInitException) {
                        logger.error("Cannot open view org.eclipse.ui.views.ProblemView");
                    }
                }
                MessageDialog.openError((Shell)shell, (String)experimentException.getErrorTitle(), (String)experimentException.getUserMessage());
            }
        });
    }

    public List<ExperimentObject> getCurrentQueue() {
        return this.queue.getCurrentQueue();
    }

    public ExperimentObject getPreviousRun(ExperimentObject experimentObject) {
        return this.queue.getPreviouslyRun(experimentObject);
    }

    public ExperimentObject getCurrentScan() {
        return this.queue.getCurrentRun();
    }
}

