/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.file;

import com.swtdesigner.SWTResourceManager;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import uk.ac.gda.common.rcp.util.IFileUtils;
import uk.ac.gda.util.io.FileUtils;

public class IFileTreeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private boolean isDisposed = false;
    private final Image folderImage;
    private final Image fileImage;
    private final Image nexusImage;
    private final Image asciiImage;
    private final DateFormat dateFormat;
    private final int[] flags;

    public IFileTreeLabelProvider() {
        this(2, 8);
    }

    public IFileTreeLabelProvider(int ... nArray) {
        this.flags = nArray;
        this.folderImage = SWTResourceManager.getImage(IFileTreeLabelProvider.class, "/icons/folder.png");
        this.fileImage = SWTResourceManager.getImage(IFileTreeLabelProvider.class, "/icons/page.png");
        this.nexusImage = SWTResourceManager.getImage(IFileTreeLabelProvider.class, "/icons/nexus.png");
        this.asciiImage = SWTResourceManager.getImage(IFileTreeLabelProvider.class, "/icons/page_white_database.png");
        this.dateFormat = new SimpleDateFormat("EEE dd MMM yyyy HH:mm:ss z");
    }

    private Image getImageFromFile(IResource iResource) {
        if (this.isDisposed()) {
            return null;
        }
        if (!iResource.exists()) {
            return null;
        }
        if (iResource instanceof IContainer) {
            return this.folderImage;
        }
        if (iResource.getName().toLowerCase().endsWith(".nxs")) {
            return this.nexusImage;
        }
        if (iResource.getName().toLowerCase().endsWith(".dat")) {
            return this.asciiImage;
        }
        return this.fileImage;
    }

    private String getTextFromFile(IResource iResource) {
        return iResource.getName();
    }

    public Image getColumnImage(Object object, int n) {
        if (n == 0) {
            return this.getImageFromFile((IResource)object);
        }
        int n2 = this.flags[n - 1];
        if (n2 == 4) {
            return this.folderImage;
        }
        return null;
    }

    public String getColumnText(Object object, int n) {
        IResource iResource = (IResource)object;
        if (!iResource.exists()) {
            return null;
        }
        if (n == 0) {
            return this.getTextFromFile(iResource);
        }
        int n2 = this.flags[n - 1];
        if (n2 == 8) {
            return this.getDate(object);
        }
        if (n2 == 2) {
            return this.getSize(object);
        }
        if (n2 == 4) {
            return this.getPath(object);
        }
        return null;
    }

    public String getSize(Object object) {
        try {
            return FileUtils.formatSize((long)IFileUtils.getLength((IResource)object), (int)3);
        }
        catch (Exception exception) {
            return "-";
        }
    }

    public String getDate(Object object) {
        try {
            return this.dateFormat.format(new Date(IFileUtils.getLastModified((IResource)object)));
        }
        catch (Exception exception) {
            return "-";
        }
    }

    public String getPath(Object object) {
        IResource iResource = (IResource)object;
        return iResource.getParent().getFullPath().toOSString();
    }

    public void dispose() {
        this.isDisposed = true;
        super.dispose();
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }
}

