/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.file;

import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import uk.ac.gda.common.rcp.util.ISortingUtils;

public class IFileTreeContentProvider
implements ITreeContentProvider {
    private IResource rootFile;

    public IFileTreeContentProvider(IResource iResource) {
        this.rootFile = iResource;
    }

    public void setPath(IResource iResource) {
        this.rootFile = iResource;
    }

    public IResource getPath() {
        return this.rootFile;
    }

    public Object[] getChildren(Object object) {
        Collection<IResource> collection;
        IResource iResource = (IResource)object;
        if (!iResource.exists()) {
            return null;
        }
        if (!(iResource instanceof IContainer)) {
            return null;
        }
        try {
            collection = ISortingUtils.getSortedFileListIgnoreHidden((IContainer)iResource, ISortingUtils.NATURAL_COMPARATOR);
        }
        catch (CoreException coreException) {
            return null;
        }
        if (collection == null) {
            return new Object[0];
        }
        return collection.toArray(new IResource[collection.size()]);
    }

    public Object getParent(Object object) {
        if (object.equals(this.rootFile)) {
            return null;
        }
        return ((IResource)object).getParent();
    }

    public boolean hasChildren(Object object) {
        IResource iResource = (IResource)object;
        if (!(iResource instanceof IContainer)) {
            return false;
        }
        if (!iResource.exists()) {
            return false;
        }
        if (iResource.isHidden()) {
            return false;
        }
        if (iResource.isPhantom()) {
            return false;
        }
        if (iResource.getLocation().toFile().isHidden()) {
            return false;
        }
        if (!iResource.isAccessible()) {
            return false;
        }
        IContainer iContainer = (IContainer)iResource;
        try {
            IResource[] iResourceArray = iContainer.members();
            return iResourceArray != null && iResourceArray.length > 0;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public Object[] getElements(Object object) {
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        return this.getChildren(object);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }
}

