/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.file;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import uk.ac.gda.common.rcp.util.IFileUtils;
import uk.ac.gda.util.io.FileUtils;

public class IFileTreeColumnProvider
extends CellLabelProvider {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("EEE dd MMM yyyy HH:mm:ss z");

    public void update(ViewerCell viewerCell) {
    }

    public String getToolTipText(Object object) {
        String string = this.getFilePath(object);
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append('\n');
        try {
            stringBuilder.append(FileUtils.formatSize((long)this.getLength(object), (int)3));
            stringBuilder.append('\n');
            stringBuilder.append(this.dateFormat.format(new Date(this.getLastModified(object))));
        }
        catch (Exception exception) {}
        return stringBuilder.toString();
    }

    private long getLength(Object object) throws Exception {
        if (object == null) {
            return 0L;
        }
        if (object instanceof File) {
            File file = (File)object;
            if (!file.exists()) {
                return 0L;
            }
            return file.length();
        }
        if (object instanceof IResource) {
            IFileUtils.getLength((IResource)object);
        }
        return 0L;
    }

    private long getLastModified(Object object) throws Exception {
        if (object == null) {
            return 0L;
        }
        if (object instanceof File) {
            File file = (File)object;
            if (!file.exists()) {
                return 0L;
            }
            return file.length();
        }
        if (object instanceof IResource) {
            IFileUtils.getLastModified((IResource)object);
        }
        return 0L;
    }

    private String getFilePath(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof File) {
            File file = (File)object;
            if (!file.exists()) {
                return null;
            }
            return file.getAbsolutePath();
        }
        if (object instanceof IResource) {
            IResource iResource = (IResource)object;
            if (!iResource.exists()) {
                return null;
            }
            return iResource.getLocation().toOSString();
        }
        return null;
    }
}

