/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.doe;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.doe.DOEUtils;
import uk.ac.gda.doe.RangeInfo;
import uk.ac.gda.ui.doe.DOEBeanProvider;
import uk.ac.gda.ui.doe.FieldColumnProvider;

public class DOEView
extends ViewPart {
    private static Logger logger = LoggerFactory.getLogger(DOEView.class);
    public static final String ID = "uk.ac.gda.ui.doe.DOEView";
    private TableViewer tableViewer;
    private List<RangeInfo> info;
    private DOEBeanProvider beansProvider;

    public DOEView() throws CoreException {
        IConfigurationElement[] iConfigurationElementArray;
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("uk.ac.common.doe.beans");
        if (iConfigurationElementArray.length != 0) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[0];
            this.beansProvider = (DOEBeanProvider)iConfigurationElement.createExecutableExtension("class");
        }
    }

    public void createPartControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        Table table = new Table(composite2, 101124);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider(this.createContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        this.createRightClickMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DOEView.this.refresh();
            }
        });
    }

    private void createTableColumns() {
        RangeInfo rangeInfo2;
        TableViewerColumn tableViewerColumn;
        while (this.tableViewer.getTable().getColumnCount() > 1) {
            this.tableViewer.getTable().getColumns()[1].dispose();
        }
        if (this.tableViewer.getTable().getColumnCount() < 1) {
            tableViewerColumn = new TableViewerColumn(this.tableViewer, 0, 0);
            tableViewerColumn.getColumn().setText("Experiment");
            tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public void update(ViewerCell viewerCell) {
                    TableItem tableItem = (TableItem)viewerCell.getViewerRow().getItem();
                    Table table = DOEView.this.tableViewer.getTable();
                    int n = table.indexOf(tableItem) + 1;
                    viewerCell.setText(" " + n);
                }
            });
            tableViewerColumn.getColumn().setWidth(120);
        }
        if (this.info == null) {
            return;
        }
        tableViewerColumn = new LinkedHashMap();
        for (RangeInfo rangeInfo2 : this.info) {
            tableViewerColumn.putAll(rangeInfo2.getColumnClasses());
        }
        rangeInfo2 = this.getColumnLabels((Map<String, Class<?>>)tableViewerColumn);
        String[] stringArray = this.getColumnProperties((Map<String, Class<?>>)tableViewerColumn);
        int n = 1;
        while (n < ((RangeInfo)rangeInfo2).length) {
            TableViewerColumn tableViewerColumn2 = new TableViewerColumn(this.tableViewer, 0, n);
            tableViewerColumn2.getColumn().setText((String)rangeInfo2[n]);
            tableViewerColumn2.setLabelProvider((CellLabelProvider)new FieldColumnProvider(stringArray));
            tableViewerColumn2.getColumn().setWidth(100);
            ++n;
        }
        this.tableViewer.setColumnProperties(stringArray);
        this.tableViewer.setInput(new Object());
    }

    private String[] getColumnLabels(Map<String, Class<?>> map) {
        ArrayList<String> arrayList = new ArrayList<String>(map.size() + 1);
        arrayList.add("Run");
        for (String string : map.keySet()) {
            String string2 = this.beansProvider.getColumnLabel(string, map.get(string));
            if (string2 == null) {
                string2 = string;
            }
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] getColumnProperties(Map<String, Class<?>> map) {
        ArrayList<String> arrayList = new ArrayList<String>(map.size() + 1);
        arrayList.add("Run");
        for (String string : map.keySet()) {
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private IContentProvider createContentProvider() {
        return new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                try {
                    return DOEView.this.info.toArray(new RangeInfo[DOEView.this.info.size()]);
                }
                catch (Exception exception) {
                    logger.error("Cannot get info from list", (Throwable)exception);
                    return null;
                }
            }
        };
    }

    private void createInfo() throws Exception {
        List<Object> list = this.beansProvider.getBeans();
        this.info = DOEUtils.getInfoFromList(list);
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    private void createRightClickMenu() {
        MenuManager menuManager = new MenuManager();
        this.tableViewer.getControl().setMenu(menuManager.createContextMenu(this.tableViewer.getControl()));
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.tableViewer);
    }

    public void refresh() {
        try {
            this.createInfo();
            this.createTableColumns();
            this.tableViewer.refresh();
        }
        catch (Exception exception) {
            logger.error("Cannot read ranges", (Throwable)exception);
        }
    }
}

