/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.dialog;

import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import uk.ac.gda.ui.dialog.GenericDialog;

public final class AuthenticationDialog
extends GenericDialog {
    private Text passwordText;
    private Text usernameText;
    protected Object result;
    private Group group;
    private String userText;
    private String passText;
    private Button automaticButton = null;
    private Boolean automatic = true;
    private Label incorrectUserPassLabel;
    private String userID;
    private String workspacePath;

    public AuthenticationDialog(Display display, int n, String string, String string2, String string3) {
        super(new Shell(display), n);
        this.setText(string);
        this.currentSelection = new Object();
        this.userID = string2;
        this.workspacePath = string3;
    }

    @Override
    public void createContents(final Shell shell, Object object) {
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.automaticButton = new Button(composite, 32);
        this.automaticButton.setSelection(true);
        this.automaticButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AuthenticationDialog.this.automatic = AuthenticationDialog.this.automatic == false;
                AuthenticationDialog.this.group.setVisible(!AuthenticationDialog.this.automaticButton.getSelection());
                ((GridData)((AuthenticationDialog)AuthenticationDialog.this).group.getLayoutData()).exclude = AuthenticationDialog.this.automaticButton.getSelection();
                if (AuthenticationDialog.this.automatic.booleanValue()) {
                    AuthenticationDialog.this.incorrectUserPassLabel.setText("");
                } else {
                    AuthenticationDialog.this.incorrectUserPassLabel.setVisible(true);
                }
                shell.layout();
            }
        });
        this.automaticButton.setToolTipText("Check to use the same logon as your OS");
        this.automaticButton.setText("Log in as " + this.userID);
        this.group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.group.setLayoutData((Object)gridData);
        gridData.minimumWidth = 310;
        gridData.exclude = true;
        Label label = new Label((Composite)this.group, 0);
        label.setText("Username:");
        this.usernameText = new Text((Composite)this.group, 2048);
        this.usernameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                AuthenticationDialog.this.userText = AuthenticationDialog.this.usernameText.getText();
            }
        });
        this.usernameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label2 = new Label((Composite)this.group, 0);
        label2.setText("Password:");
        this.passwordText = new Text((Composite)this.group, 0x400800);
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                AuthenticationDialog.this.passText = AuthenticationDialog.this.passwordText.getText();
            }
        });
        this.passwordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.group.setVisible(false);
        this.incorrectUserPassLabel = new Label(composite, 32);
        this.incorrectUserPassLabel.setVisible(true);
        this.incorrectUserPassLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.incorrectUserPassLabel.setRedraw(true);
        this.incorrectUserPassLabel.setForeground(Display.getCurrent().getSystemColor(3));
        this.incorrectUserPassLabel.setText("");
        if (this.workspacePath != null) {
            final Button button = new Button(composite, 32);
            button.setText("Use default workspace");
            button.setSelection(true);
            final Composite composite2 = new Composite(composite, 0);
            composite2.setLayoutData((Object)new GridData(4, 0, true, false));
            DirectoryFieldEditor directoryFieldEditor = new DirectoryFieldEditor("workspace.folder", "Workspace", composite2);
            directoryFieldEditor.setStringValue(this.workspacePath);
            composite2.setVisible(false);
            ((GridData)composite2.getLayoutData()).exclude = true;
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    composite2.setVisible(!button.getSelection());
                    ((GridData)composite2.getLayoutData()).exclude = button.getSelection();
                    shell.layout();
                }
            });
            directoryFieldEditor.setPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getProperty().equals("field_editor_value")) {
                        AuthenticationDialog.this.workspacePath = (String)propertyChangeEvent.getNewValue();
                    }
                }
            });
        }
        shell.setSize(355, 220);
    }

    public String getUsername() {
        return this.userText;
    }

    public String getPassword() {
        return this.passText;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public void setErrorMessage(String string) {
        this.incorrectUserPassLabel.setText(string);
        this.incorrectUserPassLabel.getParent().layout();
    }

    @Override
    public boolean shouldPack() {
        return false;
    }

    public String getWorkspacePath() {
        return this.workspacePath;
    }
}

