/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.ui.components;

import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;
import uk.ac.gda.util.ThreadManager;

public abstract class QueuedCommandWidget
extends Composite {
    private static Logger logger = LoggerFactory.getLogger(QueuedCommandWidget.class);
    private static Thread mainQueueThread;
    private static BlockingQueue<QueuedCommandWidget> queue;
    protected Label label;
    protected Link runCommand;
    private SelectionAdapter selectionListener;
    protected Collection<ValueListener> listeners;
    protected String unit;

    public QueuedCommandWidget(Composite composite, int n) {
        super(composite, n);
        QueuedCommandWidget.initQueue();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.label = new Label((Composite)this, 0);
        this.runCommand = new Link((Composite)this, 0);
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = null;
                try {
                    string = QueuedCommandWidget.this.runCommand();
                }
                catch (Exception exception) {
                    MessageDialog.openError((Shell)QueuedCommandWidget.this.getShell(), (String)"Cannot Connect to Command", (String)exception.getMessage());
                }
                QueuedCommandWidget.this.setLabelText(string);
                QueuedCommandWidget.this.layout();
            }
        };
        this.runCommand.addSelectionListener((SelectionListener)this.selectionListener);
    }

    public void dispose() {
        this.runCommand.removeSelectionListener((SelectionListener)this.selectionListener);
        super.dispose();
    }

    protected static void initQueue() {
        if (queue == null) {
            queue = new ArrayBlockingQueue<QueuedCommandWidget>(3);
        }
        if (mainQueueThread == null) {
            mainQueueThread = ThreadManager.getThread((Runnable)QueuedCommandWidget.getRunnable(), (String)("QueuedCommandWidget thread. Used to updated all " + QueuedCommandWidget.class.getName() + "'s"));
            mainQueueThread.start();
        }
    }

    protected static void clear() {
        if (mainQueueThread != null) {
            try {
                mainQueueThread.interrupt();
            }
            catch (Exception exception) {}
        }
        mainQueueThread = null;
        queue.clear();
    }

    protected static Runnable getRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            QueuedCommandWidget queuedCommandWidget;
                            if (!QueuedCommandWidget.checkActive(queuedCommandWidget = (QueuedCommandWidget)((Object)queue.take()))) {
                                return;
                            }
                            final String string = queuedCommandWidget.runCommand();
                            if (queuedCommandWidget.isDisposed()) {
                                return;
                            }
                            queuedCommandWidget.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    queuedCommandWidget.setLabelText(string);
                                    queuedCommandWidget.fireValueChangeListeners(string);
                                    queuedCommandWidget.layout();
                                }
                            });
                        }
                    }
                    catch (Exception exception) {
                        logger.error("Cannot run command in " + QueuedCommandWidget.class.getName(), (Throwable)exception);
                        continue;
                    }
                    break;
                }
            }
        };
    }

    protected void fireValueChangeListeners(String string) {
        if (this.listeners == null) {
            return;
        }
        ValueEvent valueEvent = new ValueEvent((Object)this, null);
        valueEvent.setValue(string);
        for (ValueListener valueListener : this.listeners) {
            valueListener.valueChangePerformed(valueEvent);
        }
    }

    public void addValueChangeListener(ValueListener valueListener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<ValueListener>(3);
        }
        this.listeners.add(valueListener);
    }

    protected static boolean checkActive(QueuedCommandWidget queuedCommandWidget) {
        if (Thread.currentThread().isInterrupted() || queuedCommandWidget.isDisposed()) {
            QueuedCommandWidget.clear();
            return false;
        }
        try {
            queuedCommandWidget.getDisplay().isDisposed();
        }
        catch (Exception exception) {
            QueuedCommandWidget.clear();
            return false;
        }
        return true;
    }

    protected abstract String runCommand() throws Exception;

    protected void checkSubclass() {
    }

    protected Link getRunCommand() {
        return this.runCommand;
    }

    protected Label getLabel() {
        return this.label;
    }

    public void setLinkText(String string) {
        this.runCommand.setText("<a>" + string + "</a>");
    }

    public void setLabelText(String string) {
        if (this.getUnit() == null) {
            this.label.setText(string);
        } else {
            this.label.setText(String.valueOf(string) + " " + this.getUnit());
        }
    }

    public void setLinkTooltip(String string) {
        this.runCommand.setToolTipText(string);
    }

    public void setLabelTooltip(String string) {
        this.label.setToolTipText(string);
    }

    public String getLinkText() {
        return this.runCommand.getText();
    }

    public String getLabelText() {
        return this.label.getText();
    }

    public String getLinkTooltip() {
        return this.runCommand.getToolTipText();
    }

    public String getLabelTooltip() {
        return this.label.getToolTipText();
    }

    public void updateValue() {
        try {
            QueuedCommandWidget.initQueue();
            queue.add(this);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String string) {
        this.unit = string;
    }
}

